/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.fancyconfigurator;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyCustomMiddleClickAction;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyCustomMouseWheelAction;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CircuitFancyConfigurator
implements IFancyConfigurator,
IFancyCustomMouseWheelAction,
IFancyCustomMiddleClickAction {
    private static final int SET_TO_ZERO = 2;
    private static final int SET_TO_EMPTY = 3;
    private static final int SET_TO_N = 4;
    private static final int NO_CONFIG = -1;
    final ItemStackHandler circuitSlot;

    public CircuitFancyConfigurator(ItemStackHandler circuitSlot) {
        this.circuitSlot = circuitSlot;
    }

    @Override
    public Component getTitle() {
        return Component.translatable((String)"gtceu.gui.circuit.title");
    }

    @Override
    public IGuiTexture getIcon() {
        if (IntCircuitBehaviour.isIntegratedCircuit(this.circuitSlot.getStackInSlot(0))) {
            return new ItemStackTexture(new ItemStack[]{this.circuitSlot.getStackInSlot(0)});
        }
        return new GuiTextureGroup(new IGuiTexture[]{new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack(0)}), new ItemStackTexture(new Item[]{Items.BARRIER})});
    }

    @Override
    public boolean mouseWheelMove(BiConsumer<Integer, Consumer<FriendlyByteBuf>> writeClientAction, double mouseX, double mouseY, double wheelDelta) {
        if (wheelDelta == 0.0) {
            return false;
        }
        if (!ConfigHolder.INSTANCE.machines.ghostCircuit && this.circuitSlot.getStackInSlot(0).isEmpty()) {
            return false;
        }
        int nextValue = this.getNextValue(wheelDelta > 0.0);
        if (nextValue == -1) {
            if (ConfigHolder.INSTANCE.machines.ghostCircuit) {
                this.circuitSlot.setStackInSlot(0, ItemStack.EMPTY);
                writeClientAction.accept(3, buf -> {});
            }
        } else {
            this.circuitSlot.setStackInSlot(0, IntCircuitBehaviour.stack(nextValue));
            writeClientAction.accept(4, buf -> buf.writeVarInt(nextValue));
        }
        return true;
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        switch (id) {
            case 2: {
                if (!ConfigHolder.INSTANCE.machines.ghostCircuit && this.circuitSlot.getStackInSlot(0).isEmpty()) break;
                this.circuitSlot.setStackInSlot(0, IntCircuitBehaviour.stack(0));
                break;
            }
            case 3: {
                if (ConfigHolder.INSTANCE.machines.ghostCircuit || this.circuitSlot.getStackInSlot(0).isEmpty()) {
                    this.circuitSlot.setStackInSlot(0, ItemStack.EMPTY);
                    break;
                }
                this.circuitSlot.setStackInSlot(0, IntCircuitBehaviour.stack(0));
                break;
            }
            case 4: {
                if (!ConfigHolder.INSTANCE.machines.ghostCircuit && this.circuitSlot.getStackInSlot(0).isEmpty()) break;
                this.circuitSlot.setStackInSlot(0, IntCircuitBehaviour.stack(buffer.readVarInt()));
            }
        }
    }

    @Override
    public void onMiddleClick(BiConsumer<Integer, Consumer<FriendlyByteBuf>> writeClientAction) {
        if (!ConfigHolder.INSTANCE.machines.ghostCircuit && !this.circuitSlot.getStackInSlot(0).isEmpty()) {
            this.circuitSlot.setStackInSlot(0, IntCircuitBehaviour.stack(0));
        } else {
            this.circuitSlot.setStackInSlot(0, ItemStack.EMPTY);
        }
        writeClientAction.accept(3, buf -> {});
    }

    @Override
    public Widget createConfigurator() {
        int x;
        WidgetGroup group = new WidgetGroup(0, 0, 174, 132);
        group.addWidget((Widget)new LabelWidget(9, 8, "Programmed Circuit Configuration"));
        group.addWidget(new SlotWidget((IItemHandlerModifiable)this.circuitSlot, 0, (group.getSize().width - 18) / 2, 20, !ConfigHolder.INSTANCE.machines.ghostCircuit, !ConfigHolder.INSTANCE.machines.ghostCircuit).setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.INT_CIRCUIT_OVERLAY})}));
        if (ConfigHolder.INSTANCE.machines.ghostCircuit) {
            group.addWidget((Widget)new ButtonWidget((group.getSize().width - 18) / 2, 20, 18, 18, IGuiTexture.EMPTY, clickData -> {
                if (!clickData.isRemote) {
                    this.circuitSlot.setStackInSlot(0, ItemStack.EMPTY);
                }
            }));
        }
        int idx = 0;
        for (x = 0; x <= 2; ++x) {
            for (int y = 0; y <= 8; ++y) {
                int finalIdx = idx++;
                group.addWidget((Widget)new ButtonWidget(5 + 18 * y, 48 + 18 * x, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack(finalIdx)}).scale(0.8888889f)}), clickData -> {
                    if (!clickData.isRemote) {
                        ItemStack stack = this.circuitSlot.getStackInSlot(0).copy();
                        if (IntCircuitBehaviour.isIntegratedCircuit(stack)) {
                            IntCircuitBehaviour.setCircuitConfiguration(stack, finalIdx);
                            this.circuitSlot.setStackInSlot(0, stack);
                        } else if (ConfigHolder.INSTANCE.machines.ghostCircuit) {
                            this.circuitSlot.setStackInSlot(0, IntCircuitBehaviour.stack(finalIdx));
                        }
                    }
                }));
            }
        }
        for (x = 0; x <= 5; ++x) {
            int finalIdx = x + 27;
            group.addWidget((Widget)new ButtonWidget(5 + 18 * x, 102, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack(finalIdx)}).scale(0.8888889f)}), clickData -> {
                if (!clickData.isRemote) {
                    ItemStack stack = this.circuitSlot.getStackInSlot(0).copy();
                    if (IntCircuitBehaviour.isIntegratedCircuit(stack)) {
                        IntCircuitBehaviour.setCircuitConfiguration(stack, finalIdx);
                        this.circuitSlot.setStackInSlot(0, stack);
                    } else if (ConfigHolder.INSTANCE.machines.ghostCircuit) {
                        this.circuitSlot.setStackInSlot(0, IntCircuitBehaviour.stack(finalIdx));
                    }
                }
            }));
        }
        return group;
    }

    @Override
    public List<Component> getTooltips() {
        ArrayList<Component> list = new ArrayList<Component>(IFancyConfigurator.super.getTooltips());
        list.addAll(Arrays.stream(LangHandler.getMultiLang("gtceu.gui.configurator_slot.tooltip").toArray(new MutableComponent[0])).toList());
        return list;
    }

    private int getNextValue(boolean increment) {
        int currentValue = IntCircuitBehaviour.getCircuitConfiguration(this.circuitSlot.getStackInSlot(0));
        if (increment) {
            if (currentValue == 32) {
                return 0;
            }
            if (this.circuitSlot.getStackInSlot(0).isEmpty()) {
                return 1;
            }
            return currentValue + 1;
        }
        if (this.circuitSlot.getStackInSlot(0).isEmpty() || currentValue == 0 && !ConfigHolder.INSTANCE.machines.ghostCircuit) {
            return 32;
        }
        if (currentValue == 1 && ConfigHolder.INSTANCE.machines.ghostCircuit) {
            return -1;
        }
        return currentValue - 1;
    }
}

