/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature.multiblock;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.config.ConfigHolder;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.state.properties.BooleanProperty;

public interface IMaintenanceMachine
extends IMultiPart {
    public static final BooleanProperty MAINTENANCE_TAPED_PROPERTY = GTMachineModelProperties.IS_TAPED;
    public static final byte ALL_PROBLEMS = 0;
    public static final byte NO_PROBLEMS = 63;

    public boolean isFullAuto();

    public void setTaped(boolean var1);

    public boolean isTaped();

    public byte startProblems();

    public byte getMaintenanceProblems();

    public void setMaintenanceProblems(byte var1);

    public int getTimeActive();

    public void setTimeActive(int var1);

    default public float getDurationMultiplier() {
        return 1.0f;
    }

    default public float getTimeMultiplier() {
        return 1.0f;
    }

    @Override
    default public boolean canShared() {
        return false;
    }

    default public void calculateMaintenance(IMaintenanceMachine maintenanceMachine, int duration) {
        if (!ConfigHolder.INSTANCE.machines.enableMaintenance || maintenanceMachine.isFullAuto()) {
            return;
        }
        this.setTimeActive(this.getTimeActive() + duration);
        float rate = (float)ConfigHolder.INSTANCE.machines.maintenanceCheckRate / maintenanceMachine.getTimeMultiplier();
        if ((float)this.getTimeActive() >= rate) {
            this.setTimeActive(0);
            if (GTValues.RNG.nextInt(6000) == 0) {
                this.causeRandomMaintenanceProblems();
                maintenanceMachine.setTaped(false);
            }
        }
    }

    default public void calculateMaintenance(IMaintenanceMachine maintenanceMachine) {
        this.calculateMaintenance(maintenanceMachine, 1);
    }

    default public int getNumMaintenanceProblems() {
        return ConfigHolder.INSTANCE.machines.enableMaintenance ? 6 - Integer.bitCount(this.getMaintenanceProblems()) : 0;
    }

    default public boolean hasMaintenanceProblems() {
        return ConfigHolder.INSTANCE.machines.enableMaintenance && this.getMaintenanceProblems() < 63;
    }

    default public void setMaintenanceFixed(int index) {
        this.setMaintenanceProblems((byte)(this.getMaintenanceProblems() | (byte)(1 << index)));
    }

    default public void causeRandomMaintenanceProblems() {
        this.setMaintenanceProblems((byte)(this.getMaintenanceProblems() & (byte)(~(1 << GTValues.RNG.nextInt(6)))));
    }

    @Override
    default public boolean onWorking(IWorkableMultiController controller) {
        this.calculateMaintenance(this);
        if (this.hasMaintenanceProblems()) {
            controller.getRecipeLogic().markLastRecipeDirty();
        }
        return true;
    }

    @Override
    default public GTRecipe modifyRecipe(GTRecipe recipe) {
        if (ConfigHolder.INSTANCE.machines.enableMaintenance) {
            if (this.hasMaintenanceProblems()) {
                return null;
            }
            float durationMultiplier = this.getDurationMultiplier();
            if (durationMultiplier != 1.0f) {
                recipe = recipe.copy();
                recipe.duration = (int)((float)recipe.duration * durationMultiplier);
            }
        }
        return recipe;
    }

    @Override
    default public void attachFancyTooltipsToController(IMultiController controller, TooltipsPanel tooltipsPanel) {
        this.attachTooltips(tooltipsPanel);
    }

    @Override
    default public void attachTooltips(TooltipsPanel tooltipsPanel) {
        if (ConfigHolder.INSTANCE.machines.enableMaintenance) {
            tooltipsPanel.attachTooltips(new IFancyTooltip.Basic(() -> GuiTextures.MAINTENANCE_ICON, () -> {
                ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
                tooltips.add(Component.translatable((String)"gtceu.multiblock.universal.has_problems_header").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
                if ((this.getMaintenanceProblems() & 1) == 0) {
                    tooltips.add(Component.translatable((String)"gtceu.multiblock.universal.problem.wrench"));
                }
                if ((this.getMaintenanceProblems() >> 1 & 1) == 0) {
                    tooltips.add(Component.translatable((String)"gtceu.multiblock.universal.problem.screwdriver"));
                }
                if ((this.getMaintenanceProblems() >> 2 & 1) == 0) {
                    tooltips.add(Component.translatable((String)"gtceu.multiblock.universal.problem.soft_mallet"));
                }
                if ((this.getMaintenanceProblems() >> 3 & 1) == 0) {
                    tooltips.add(Component.translatable((String)"gtceu.multiblock.universal.problem.hard_hammer"));
                }
                if ((this.getMaintenanceProblems() >> 4 & 1) == 0) {
                    tooltips.add(Component.translatable((String)"gtceu.multiblock.universal.problem.wire_cutter"));
                }
                if ((this.getMaintenanceProblems() >> 5 & 1) == 0) {
                    tooltips.add(Component.translatable((String)"gtceu.multiblock.universal.problem.crowbar"));
                }
                return tooltips;
            }, this::hasMaintenanceProblems, () -> null));
        }
    }
}

