/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.steam;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class SteamWorkableMachine
extends SteamMachine
implements IRecipeLogicMachine,
IMufflableMachine,
IMachineLife {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SteamWorkableMachine.class, SteamMachine.MANAGED_FIELD_HOLDER);
    @Nullable
    private ICleanroomProvider cleanroom;
    @Persisted
    @DescSynced
    public final RecipeLogic recipeLogic;
    public final GTRecipeType[] recipeTypes = this.getDefinition().getRecipeTypes();
    public int activeRecipeType = 0;
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacing;
    @Persisted
    @DescSynced
    protected boolean isMuffled;
    protected boolean previouslyMuffled = true;
    protected final Map<IO, List<RecipeHandlerList>> capabilitiesProxy;
    protected final Map<IO, Map<RecipeCapability<?>, List<IRecipeHandler<?>>>> capabilitiesFlat;
    protected final List<ISubscription> traitSubscriptions;

    public SteamWorkableMachine(IMachineBlockEntity holder, boolean isHighPressure, Object ... args) {
        super(holder, isHighPressure, args);
        this.recipeLogic = this.createRecipeLogic(args);
        this.capabilitiesProxy = new EnumMap<IO, List<RecipeHandlerList>>(IO.class);
        this.capabilitiesFlat = new EnumMap(IO.class);
        this.traitSubscriptions = new ArrayList<ISubscription>();
        this.outputFacing = this.hasFrontFacing() ? this.getFrontFacing().getOpposite() : Direction.UP;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Object2ObjectOpenHashMap ioTraits = new Object2ObjectOpenHashMap();
        for (MachineTrait machineTrait : this.getTraits()) {
            if (!(machineTrait instanceof IRecipeHandlerTrait)) continue;
            IRecipeHandlerTrait handlerTrait = (IRecipeHandlerTrait)((Object)machineTrait);
            ioTraits.computeIfAbsent(handlerTrait.getHandlerIO(), i -> new ArrayList()).add(handlerTrait);
        }
        for (Map.Entry entry : ioTraits.entrySet()) {
            RecipeHandlerList handlerList = RecipeHandlerList.of((IO)entry.getKey(), (Iterable)entry.getValue());
            this.addHandlerList(handlerList);
            this.traitSubscriptions.add(handlerList.subscribe(this.recipeLogic::updateTickSubscription));
        }
    }

    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new RecipeLogic(this);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.traitSubscriptions.forEach(ISubscription::unsubscribe);
        this.traitSubscriptions.clear();
        this.capabilitiesProxy.clear();
        this.capabilitiesFlat.clear();
        this.recipeLogic.inValid();
    }

    public boolean hasOutputFacing() {
        return true;
    }

    public void setOutputFacing(@NotNull Direction outputFacing) {
        if (this.hasOutputFacing() && (!this.hasFrontFacing() || this.outputFacing != this.getFrontFacing())) {
            this.outputFacing = outputFacing;
        }
    }

    @Nullable
    public Direction getOutputFacing() {
        if (this.hasOutputFacing()) {
            return this.outputFacing;
        }
        return null;
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        if (facing == this.getOutputFacing()) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!playerIn.isShiftKeyDown()) {
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return InteractionResult.PASS;
            }
            this.setOutputFacing(gridSide);
            return InteractionResult.sidedSuccess((boolean)playerIn.level().isClientSide);
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    public boolean keepSubscribing() {
        return false;
    }

    @Override
    @NotNull
    public GTRecipeType getRecipeType() {
        return this.recipeTypes[this.activeRecipeType];
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.previouslyMuffled != this.isMuffled) {
            this.previouslyMuffled = this.isMuffled;
            if (this.recipeLogic != null) {
                this.recipeLogic.updateSound();
            }
        }
    }

    @Override
    @Nullable
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (!(!toolTypes.contains(GTToolType.WRENCH) || player.isShiftKeyDown() || this.hasFrontFacing() && side == this.getFrontFacing())) {
            return GuiTextures.TOOL_IO_FACING_ROTATION;
        }
        return super.sideTips(player, pos, state, toolTypes, side);
    }

    @Override
    @Nullable
    @Generated
    public ICleanroomProvider getCleanroom() {
        return this.cleanroom;
    }

    @Override
    @Generated
    public void setCleanroom(@Nullable ICleanroomProvider cleanroom) {
        this.cleanroom = cleanroom;
    }

    @Override
    @Generated
    public RecipeLogic getRecipeLogic() {
        return this.recipeLogic;
    }

    @Override
    @Generated
    public GTRecipeType[] getRecipeTypes() {
        return this.recipeTypes;
    }

    @Override
    @Generated
    public int getActiveRecipeType() {
        return this.activeRecipeType;
    }

    @Override
    @Generated
    public void setActiveRecipeType(int activeRecipeType) {
        this.activeRecipeType = activeRecipeType;
    }

    @Override
    @Generated
    public boolean isMuffled() {
        return this.isMuffled;
    }

    @Override
    @Generated
    public void setMuffled(boolean isMuffled) {
        this.isMuffled = isMuffled;
    }

    @Override
    @Generated
    public Map<IO, List<RecipeHandlerList>> getCapabilitiesProxy() {
        return this.capabilitiesProxy;
    }

    @Override
    @Generated
    public Map<IO, Map<RecipeCapability<?>, List<IRecipeHandler<?>>>> getCapabilitiesFlat() {
        return this.capabilitiesFlat;
    }
}

