/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class IOFilteredInvWrapper
extends CombinedInvWrapper {
    private final IO io;
    private final Predicate<ItemStack> inFilter;
    private final Predicate<ItemStack> outFilter;

    public IOFilteredInvWrapper(List<IItemHandlerModifiable> handlers, IO io, Predicate<ItemStack> inFilter, Predicate<ItemStack> outFilter) {
        super((IItemHandlerModifiable[])handlers.toArray(IItemHandlerModifiable[]::new));
        this.io = io;
        this.inFilter = inFilter;
        this.outFilter = outFilter;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (!this.io.support(IO.IN) || !this.inFilter.test(stack)) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (!this.io.support(IO.OUT)) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = super.extractItem(slot, amount, true);
        if (stack.isEmpty() || !this.outFilter.test(stack)) {
            return ItemStack.EMPTY;
        }
        return simulate ? stack : super.extractItem(slot, amount, false);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        Predicate<ItemStack> filter = s -> true;
        if (this.io.support(IO.IN)) {
            filter = this.inFilter.and(filter);
        }
        if (this.io.support(IO.OUT)) {
            filter = this.outFilter.and(filter);
        }
        return filter.test(stack) && super.isItemValid(slot, stack);
    }
}

