/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.blockentity.FluidPipeBlockEntity;
import com.gregtechceu.gtceu.common.blockentity.ItemPipeBlockEntity;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.ReadOnlyManaged;
import com.lowdragmc.lowdraglib.syncdata.annotation.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.Nullable;

public class PipeCoverContainer
implements ICoverable,
IEnhancedManaged {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PipeCoverContainer.class);
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
    private final IPipeNode<?, ?> pipeTile;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior up;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior down;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior north;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior south;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior west;
    @DescSynced
    @Persisted
    @UpdateListener(methodName="onCoverSet")
    @ReadOnlyManaged(onDirtyMethod="onCoverDirty", serializeMethod="serializeCoverUid", deserializeMethod="deserializeCoverUid")
    private CoverBehavior east;

    public PipeCoverContainer(IPipeNode<?, ?> pipeTile) {
        this.pipeTile = pipeTile;
    }

    private void onCoverSet(CoverBehavior newValue, CoverBehavior oldValue) {
        if (newValue != oldValue && (newValue == null || oldValue == null)) {
            this.scheduleRenderUpdate();
        }
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onChanged() {
        Level level = this.getLevel();
        if (level != null && !level.isClientSide && level.getServer() != null) {
            level.getServer().execute(this::markDirty);
        }
    }

    @Override
    public Level getLevel() {
        return this.pipeTile.getPipeLevel();
    }

    @Override
    public BlockPos getPos() {
        return this.pipeTile.getPipePos();
    }

    @Override
    public long getOffsetTimer() {
        return this.pipeTile.getOffsetTimer();
    }

    @Override
    public void markDirty() {
        this.pipeTile.markAsDirty();
    }

    @Override
    public void notifyBlockUpdate() {
        this.pipeTile.notifyBlockUpdate();
    }

    @Override
    public void scheduleRenderUpdate() {
        this.pipeTile.scheduleRenderUpdate();
    }

    @Override
    public void scheduleNeighborShapeUpdate() {
        this.pipeTile.scheduleNeighborShapeUpdate();
    }

    @Override
    public boolean isInValid() {
        return this.pipeTile.isInValid();
    }

    @Override
    public boolean canPlaceCoverOnSide(CoverDefinition definition, Direction side) {
        return this.getCoverAtSide(side) == null;
    }

    @Override
    public double getCoverPlateThickness() {
        float thickness = ((IPipeType)this.pipeTile.getPipeType()).getThickness();
        if (thickness >= 1.0f) {
            return 0.0;
        }
        return Math.min(0.0625, (1.0 - (double)thickness) / 2.0);
    }

    @Override
    public Direction getFrontFacing() {
        return Direction.NORTH;
    }

    @Override
    public boolean shouldRenderBackSide() {
        return true;
    }

    @Override
    @Nullable
    public TickableSubscription subscribeServerTick(Runnable runnable) {
        return this.pipeTile.subscribeServerTick(runnable);
    }

    @Override
    public void unsubscribe(@Nullable TickableSubscription current) {
        this.pipeTile.unsubscribe(current);
    }

    @Override
    public IItemHandlerModifiable getItemHandlerCap(Direction side, boolean useCoverCapability) {
        IPipeNode<?, ?> iPipeNode = this.pipeTile;
        if (iPipeNode instanceof ItemPipeBlockEntity) {
            ItemPipeBlockEntity itemPipe = (ItemPipeBlockEntity)iPipeNode;
            return this.getLevel() instanceof ServerLevel ? itemPipe.getHandler(side, useCoverCapability) : (IItemHandlerModifiable)EmptyHandler.INSTANCE;
        }
        return null;
    }

    @Override
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        IPipeNode<?, ?> iPipeNode = this.pipeTile;
        if (iPipeNode instanceof FluidPipeBlockEntity) {
            FluidPipeBlockEntity fluidPipe = (FluidPipeBlockEntity)iPipeNode;
            return fluidPipe.getTankList(side);
        }
        return null;
    }

    @Override
    public CoverBehavior getCoverAtSide(Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> this.up;
            case Direction.SOUTH -> this.south;
            case Direction.WEST -> this.west;
            case Direction.DOWN -> this.down;
            case Direction.EAST -> this.east;
            case Direction.NORTH -> this.north;
        };
    }

    @Override
    public void setCoverAtSide(@Nullable CoverBehavior coverBehavior, Direction side) {
        CoverBehavior previousCover = this.getCoverAtSide(side);
        switch (side) {
            case UP: {
                this.up = coverBehavior;
                break;
            }
            case SOUTH: {
                this.south = coverBehavior;
                break;
            }
            case WEST: {
                this.west = coverBehavior;
                break;
            }
            case DOWN: {
                this.down = coverBehavior;
                break;
            }
            case EAST: {
                this.east = coverBehavior;
                break;
            }
            case NORTH: {
                this.north = coverBehavior;
            }
        }
        if (coverBehavior != null) {
            coverBehavior.getSyncStorage().markAllDirty();
            if (coverBehavior.canPipePassThrough()) {
                this.pipeTile.setConnection(side, true, false);
            }
        } else if (previousCover != null && previousCover.canPipePassThrough()) {
            this.pipeTile.setConnection(side, false, false);
        }
    }

    private boolean onCoverDirty(CoverBehavior coverBehavior) {
        return coverBehavior != null && (coverBehavior.getSyncStorage().hasDirtySyncFields() || coverBehavior.getSyncStorage().hasDirtyPersistedFields());
    }

    private CompoundTag serializeCoverUid(CoverBehavior coverBehavior) {
        CompoundTag uid = new CompoundTag();
        uid.putString("id", ((ResourceLocation)GTRegistries.COVERS.getKey(coverBehavior.coverDefinition)).toString());
        uid.putInt("side", coverBehavior.attachedSide.ordinal());
        return uid;
    }

    private CoverBehavior deserializeCoverUid(CompoundTag uid) {
        ResourceLocation definitionId = new ResourceLocation(uid.getString("id"));
        Direction side = GTUtil.DIRECTIONS[uid.getInt("side")];
        CoverDefinition definition = (CoverDefinition)GTRegistries.COVERS.get(definitionId);
        if (definition != null) {
            return definition.createCoverBehavior(this, side);
        }
        GTCEu.LOGGER.error("couldn't find cover definition {}", (Object)definitionId);
        throw new RuntimeException();
    }

    @Generated
    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }
}

