/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.category;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTRecipeCategory {
    public static final GTRecipeCategory DEFAULT = new GTRecipeCategory("default", GTRecipeTypes.DUMMY_RECIPES);
    public final ResourceLocation registryKey;
    public final String name;
    private final GTRecipeType recipeType;
    private final String languageKey;
    @Nullable
    private IGuiTexture icon = null;
    private boolean isXEIVisible = true;

    public GTRecipeCategory(@NotNull GTRecipeType recipeType) {
        this.recipeType = recipeType;
        this.name = recipeType.registryName.getPath();
        this.registryKey = recipeType.registryName;
        this.languageKey = recipeType.registryName.toLanguageKey();
    }

    public GTRecipeCategory(@NotNull String categoryName, @NotNull GTRecipeType recipeType) {
        this.recipeType = recipeType;
        this.name = categoryName;
        this.registryKey = GTCEu.id(categoryName);
        this.languageKey = "%s.recipe.category.%s".formatted("gtceu", categoryName);
    }

    public static GTRecipeCategory registerDefault(@NotNull GTRecipeType recipeType) {
        GTRecipeCategory category = new GTRecipeCategory(recipeType);
        GTRegistries.RECIPE_CATEGORIES.register(category.registryKey, category);
        return category;
    }

    public IGuiTexture getIcon() {
        if (this.icon == null) {
            this.icon = this.recipeType.getIconSupplier() != null ? new ItemStackTexture(new ItemStack[]{this.recipeType.getIconSupplier().get()}) : new ItemStackTexture(new Item[]{Items.BARRIER});
        }
        return this.icon;
    }

    public void addRecipe(GTRecipe recipe) {
        this.recipeType.addToCategoryMap(this, recipe);
    }

    public boolean shouldRegisterDisplays() {
        return (this.isXEIVisible || GTCEu.isDev()) && this != GTRecipeTypes.FURNACE_RECIPES.getCategory();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GTRecipeCategory)) {
            return false;
        }
        GTRecipeCategory that = (GTRecipeCategory)obj;
        return this.registryKey.equals((Object)that.registryKey);
    }

    public int hashCode() {
        return this.registryKey.hashCode();
    }

    public String toString() {
        return "GTRecipeCategory{%s}".formatted(this.name);
    }

    @Generated
    public GTRecipeType getRecipeType() {
        return this.recipeType;
    }

    @Generated
    public String getLanguageKey() {
        return this.languageKey;
    }

    @NotNull
    @Generated
    public GTRecipeCategory setIcon(@Nullable IGuiTexture icon) {
        this.icon = icon;
        return this;
    }

    @Generated
    public boolean isXEIVisible() {
        return this.isXEIVisible;
    }

    @NotNull
    @Generated
    public GTRecipeCategory setXEIVisible(boolean isXEIVisible) {
        this.isXEIVisible = isXEIVisible;
        return this;
    }
}

