/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.chance.boost.ChanceBoostFunction;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GradientUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Content {
    public final Object content;
    public final int chance;
    public final int maxChance;
    public final int tierChanceBoost;

    public Content(Object content, int chance, int maxChance, int tierChanceBoost) {
        this.content = content;
        this.chance = chance;
        this.maxChance = maxChance;
        this.tierChanceBoost = this.fixBoost(tierChanceBoost);
    }

    public static <T> Codec<Content> codec(RecipeCapability<T> capability) {
        return RecordCodecBuilder.create(instance -> instance.group((App)capability.serializer.codec().fieldOf("content").forGetter(val -> capability.of(val.content)), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("chance", (Object)ChanceLogic.getMaxChancedValue()).forGetter(val -> val.chance), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("maxChance", (Object)ChanceLogic.getMaxChancedValue()).forGetter(val -> val.maxChance), (App)Codec.INT.optionalFieldOf("tierChanceBoost", (Object)0).forGetter(val -> val.tierChanceBoost)).apply((Applicative)instance, Content::new));
    }

    public Content copy(RecipeCapability<?> capability) {
        return new Content(capability.copyContent(this.content), this.chance, this.maxChance, this.tierChanceBoost);
    }

    public Content copy(RecipeCapability<?> capability, @NotNull ContentModifier modifier) {
        if (modifier == ContentModifier.IDENTITY || this.chance < this.maxChance) {
            return this.copy(capability);
        }
        return new Content(capability.copyContent(this.content, modifier), this.chance, this.maxChance, this.tierChanceBoost);
    }

    public Content copyChanced(RecipeCapability<?> capability, @NotNull ContentModifier modifier) {
        if (modifier == ContentModifier.IDENTITY) {
            return this.copy(capability);
        }
        return new Content(capability.copyContent(this.content, modifier), this.chance, this.maxChance, this.tierChanceBoost);
    }

    public boolean isChanced() {
        return this.chance > 0 && this.chance < this.maxChance;
    }

    private int fixBoost(int chanceBoost) {
        float error = (float)ChanceLogic.getMaxChancedValue() / (float)this.maxChance;
        int fixed = Math.round((float)Math.abs(chanceBoost) / error);
        return chanceBoost < 0 ? -fixed : fixed;
    }

    public IGuiTexture createOverlay(final boolean perTick, final int recipeTier, final int chanceTier, final @Nullable ChanceBoostFunction function) {
        return new IGuiTexture(){

            @OnlyIn(value=Dist.CLIENT)
            public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
                Content.this.drawChance(graphics, x, y, width, height, recipeTier, chanceTier, function);
                Content.this.drawRangeAmount(graphics, x, y, width, height);
                Content.this.drawFluidAmount(graphics, x, y, width, height);
                if (perTick) {
                    Content.this.drawTick(graphics, x, y, width, height);
                }
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawRangeAmount(GuiGraphics graphics, float x, float y, int width, int height) {
        Object object = this.content;
        if (object instanceof IntProviderIngredient) {
            IntProviderIngredient ingredient = (IntProviderIngredient)((Object)object);
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 400.0f);
            graphics.pose().scale(0.5f, 0.5f, 1.0f);
            int min = ingredient.getCountProvider().getMinValue();
            int max = ingredient.getCountProvider().getMaxValue();
            String s = String.format("%s-%s", min, max);
            int color = 0xFFFFFF;
            Font fontRenderer = Minecraft.getInstance().font;
            if (s.length() > 5) {
                s = "X-Y";
                color = ChatFormatting.GOLD.getColor();
            }
            graphics.drawString(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.width(s) + 21.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f), color, true);
            graphics.pose().popPose();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawFluidAmount(GuiGraphics graphics, float x, float y, int width, int height) {
        Object object = this.content;
        if (object instanceof FluidIngredient) {
            String s;
            int color;
            FluidIngredient ingredient = (FluidIngredient)object;
            graphics.pose().pushPose();
            graphics.pose().translate(0.0f, 0.0f, 400.0f);
            graphics.pose().scale(0.5f, 0.5f, 1.0f);
            Font fontRenderer = Minecraft.getInstance().font;
            if (this.content instanceof IntProviderFluidIngredient) {
                color = ChatFormatting.GOLD.getColor();
                s = "X-Y";
            } else {
                int amount = ingredient.getAmount();
                color = 0xFFFFFF;
                s = FormattingUtil.formatBuckets(amount);
                if (fontRenderer.width(s) > 32) {
                    s = FormattingUtil.formatNumberReadable(amount, true, FormattingUtil.DECIMAL_FORMAT_1F, "B");
                }
                if (fontRenderer.width(s) > 32) {
                    s = FormattingUtil.formatNumberReadable(amount, true, FormattingUtil.DECIMAL_FORMAT_0F, "B");
                }
            }
            graphics.drawString(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.width(s) + 22.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f), color, true);
            graphics.pose().popPose();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawChance(GuiGraphics graphics, float x, float y, int width, int height, int recipeTier, int chanceTier, @Nullable ChanceBoostFunction function) {
        if (this.chance == ChanceLogic.getMaxChancedValue()) {
            return;
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 400.0f);
        graphics.pose().scale(0.5f, 0.5f, 1.0f);
        ChanceBoostFunction func = function == null ? ChanceBoostFunction.NONE : function;
        int chance = func.getBoostedChance(this, recipeTier, chanceTier);
        float chanceFloat = 1.0f * (float)chance / (float)this.maxChance;
        String percent = FormattingUtil.formatNumber2Places(100.0f * chanceFloat);
        String s = chance == 0 ? LocalizationUtils.format((String)"gtceu.gui.content.chance_nc_short", (Object[])new Object[0]) : percent + "%";
        int color = chance == 0 ? 0xFF0000 : GradientUtil.toRGB(Mth.lerp((float)chanceFloat, (float)29.0f, (float)167.0f), 100.0f, 50.0f);
        Font fontRenderer = Minecraft.getInstance().font;
        graphics.drawString(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.width(s) + 23.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f - (float)height), color, true);
        graphics.pose().popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawTick(GuiGraphics graphics, float x, float y, int width, int height) {
        graphics.pose().pushPose();
        RenderSystem.disableDepthTest();
        graphics.pose().translate(0.0f, 0.0f, 400.0f);
        graphics.pose().scale(0.5f, 0.5f, 1.0f);
        String s = LocalizationUtils.format((String)"gtceu.gui.content.tips.per_tick_short", (Object[])new Object[0]);
        int color = 0xFFFF00;
        Font fontRenderer = Minecraft.getInstance().font;
        graphics.drawString(fontRenderer, s, (int)((x + (float)width / 3.0f) * 2.0f - (float)fontRenderer.width(s) + 23.0f), (int)((y + (float)height / 3.0f + 6.0f) * 2.0f - (float)height + (float)(this.chance == ChanceLogic.getMaxChancedValue() ? 0 : 10)), color);
        graphics.pose().popPose();
    }

    public String toString() {
        return "Content{content=" + String.valueOf(this.content) + ", chance=" + this.chance + ", maxChance=" + this.maxChance + ", tierChanceBoost=" + this.tierChanceBoost + "}";
    }

    @Generated
    public Object getContent() {
        return this.content;
    }
}

