/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NBTPredicate;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NBTPredicates;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;

public class AllNBTPredicate
extends NBTPredicate {
    public static final String TYPE = "all";
    private final List<NBTPredicate> children;

    @Override
    public String getType() {
        return TYPE;
    }

    public AllNBTPredicate(List<NBTPredicate> children) {
        this.children = children;
    }

    @Override
    public boolean test(CompoundTag tag) {
        for (NBTPredicate child : this.children) {
            if (child.test(tag)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JsonObject toJson() {
        JsonObject object = super.toJson();
        JsonArray childArray = new JsonArray();
        for (NBTPredicate child : this.children) {
            childArray.add((JsonElement)child.toJson());
        }
        object.add("children", (JsonElement)childArray);
        return object;
    }

    public static NBTPredicate fromJson(JsonObject json) {
        if (!json.has("children") || !json.has("type")) {
            throw new IllegalStateException("Could not deserialize AllNBTPredicate: " + String.valueOf(json));
        }
        if (!json.get("type").getAsString().equals(TYPE)) {
            throw new IllegalStateException("Trying to deserialize AllNBTPredicate but was something else: " + String.valueOf(json));
        }
        ArrayList<NBTPredicate> children = new ArrayList<NBTPredicate>();
        for (JsonElement element : json.getAsJsonArray("children")) {
            children.add(NBTPredicates.fromJson(element.getAsJsonObject()));
        }
        return new AllNBTPredicate(children);
    }

    public String toString() {
        return "AllNBTPredicate{children=[" + this.children.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]}";
    }
}

