/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.AllNBTPredicate;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.AnyNBTPredicate;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.ComparisonNBTPredicate;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.EqualsNBTPredicate;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NBTPredicate;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.NotNBTPredicate;
import com.gregtechceu.gtceu.api.recipe.ingredient.nbtpredicate.TrueNBTPredicate;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public final class NBTPredicates {
    public static final Map<String, Function<JsonObject, NBTPredicate>> predicateCodecs = new Object2ObjectOpenHashMap();

    private NBTPredicates() {
    }

    public static NBTPredicate eqInt(String key, int value) {
        return NBTPredicates.eq(key, value);
    }

    @HideFromJS
    public static NBTPredicate eq(String key, int value) {
        return new EqualsNBTPredicate(key, (Tag)IntTag.valueOf((int)value));
    }

    public static NBTPredicate eqFloat(String key, float value) {
        return NBTPredicates.eq(key, value);
    }

    @HideFromJS
    public static NBTPredicate eq(String key, float value) {
        return new EqualsNBTPredicate(key, (Tag)FloatTag.valueOf((float)value));
    }

    public static NBTPredicate eqDouble(String key, double value) {
        return NBTPredicates.eq(key, value);
    }

    @HideFromJS
    public static NBTPredicate eq(String key, double value) {
        return new EqualsNBTPredicate(key, (Tag)DoubleTag.valueOf((double)value));
    }

    public static NBTPredicate eqBool(String key, boolean value) {
        return NBTPredicates.eq(key, value);
    }

    @HideFromJS
    public static NBTPredicate eq(String key, boolean value) {
        return new EqualsNBTPredicate(key, (Tag)ByteTag.valueOf((boolean)value));
    }

    public static NBTPredicate eqByte(String key, byte value) {
        return NBTPredicates.eq(key, value);
    }

    @HideFromJS
    public static NBTPredicate eq(String key, byte value) {
        return new EqualsNBTPredicate(key, (Tag)ByteTag.valueOf((byte)value));
    }

    public static NBTPredicate eqTag(String key, Tag value) {
        return NBTPredicates.eq(key, value);
    }

    @HideFromJS
    public static NBTPredicate eq(String key, Tag value) {
        return new EqualsNBTPredicate(key, value);
    }

    public static NBTPredicate eqString(String key, String value) {
        return NBTPredicates.eq(key, value);
    }

    @HideFromJS
    public static NBTPredicate eq(String key, String value) {
        return new EqualsNBTPredicate(key, (Tag)StringTag.valueOf((String)value));
    }

    public static NBTPredicate neqInt(String key, int value) {
        return NBTPredicates.neq(key, value);
    }

    @HideFromJS
    public static NBTPredicate neq(String key, int value) {
        return new EqualsNBTPredicate(key, (Tag)IntTag.valueOf((int)value), true);
    }

    public static NBTPredicate neqFloat(String key, float value) {
        return NBTPredicates.neq(key, value);
    }

    @HideFromJS
    public static NBTPredicate neq(String key, float value) {
        return new EqualsNBTPredicate(key, (Tag)FloatTag.valueOf((float)value), true);
    }

    public static NBTPredicate neqDouble(String key, double value) {
        return NBTPredicates.neq(key, value);
    }

    @HideFromJS
    public static NBTPredicate neq(String key, double value) {
        return new EqualsNBTPredicate(key, (Tag)DoubleTag.valueOf((double)value), true);
    }

    public static NBTPredicate neqBool(String key, boolean value) {
        return NBTPredicates.neq(key, value);
    }

    @HideFromJS
    public static NBTPredicate neq(String key, boolean value) {
        return new EqualsNBTPredicate(key, (Tag)ByteTag.valueOf((boolean)value), true);
    }

    public static NBTPredicate neqByte(String key, byte value) {
        return NBTPredicates.neq(key, value);
    }

    @HideFromJS
    public static NBTPredicate neq(String key, byte value) {
        return new EqualsNBTPredicate(key, (Tag)ByteTag.valueOf((byte)value), true);
    }

    public static NBTPredicate neqTag(String key, Tag value) {
        return NBTPredicates.neq(key, value);
    }

    @HideFromJS
    public static NBTPredicate neq(String key, Tag value) {
        return new EqualsNBTPredicate(key, value, true);
    }

    public static NBTPredicate neqString(String key, String value) {
        return NBTPredicates.neq(key, value);
    }

    @HideFromJS
    public static NBTPredicate neq(String key, String value) {
        return new EqualsNBTPredicate(key, (Tag)StringTag.valueOf((String)value), true);
    }

    public static NBTPredicate lte(String key, double value) {
        return new ComparisonNBTPredicate(key, value, true, true);
    }

    public static NBTPredicate lt(String key, double value) {
        return new ComparisonNBTPredicate(key, value, true, false);
    }

    public static NBTPredicate gte(String key, double value) {
        return new ComparisonNBTPredicate(key, value, false, true);
    }

    public static NBTPredicate gt(String key, double value) {
        return new ComparisonNBTPredicate(key, value, false, false);
    }

    public static NBTPredicate any(NBTPredicate ... predicates) {
        return new AnyNBTPredicate(List.of(predicates));
    }

    @HideFromJS
    public static NBTPredicate any(List<NBTPredicate> predicates) {
        return new AnyNBTPredicate(predicates);
    }

    public static NBTPredicate all(NBTPredicate ... predicates) {
        return new AllNBTPredicate(List.of(predicates));
    }

    @HideFromJS
    public static NBTPredicate all(List<NBTPredicate> predicates) {
        return new AllNBTPredicate(predicates);
    }

    public static NBTPredicate not(NBTPredicate predicate) {
        return new NotNBTPredicate(predicate);
    }

    public static NBTPredicate fromJson(JsonObject json) {
        if (!json.has("type")) {
            throw new IllegalStateException("Can't deserialize JSON without operation key: " + String.valueOf(json));
        }
        String op = json.get("type").getAsString();
        return predicateCodecs.get(op).apply(json);
    }

    static {
        predicateCodecs.put("true", TrueNBTPredicate::fromJson);
        predicateCodecs.put("equals", EqualsNBTPredicate::fromJson);
        predicateCodecs.put("compare", ComparisonNBTPredicate::fromJson);
        predicateCodecs.put("all", AllNBTPredicate::fromJson);
        predicateCodecs.put("any", AnyNBTPredicate::fromJson);
        predicateCodecs.put("not", NotNBTPredicate::fromJson);
    }
}

