/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup.ingredient.item;

import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.MapIngredientTypeManager;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.item.ItemStackMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.item.ItemTagMapIngredient;
import com.gregtechceu.gtceu.core.mixins.forge.IntersectionIngredientAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import org.jetbrains.annotations.NotNull;

public class IntersectionMapIngredient
extends AbstractMapIngredient {
    protected List<AbstractMapIngredient> children;

    public IntersectionMapIngredient(List<AbstractMapIngredient> children) {
        this.children = children;
        this.children.sort(Comparator.comparingInt(AbstractMapIngredient::hashCode));
    }

    @NotNull
    public static List<AbstractMapIngredient> from(IntersectionIngredient ingredient) {
        List<Ingredient> originalChildren = ((IntersectionIngredientAccessor)ingredient).getChildren();
        ObjectArrayList mapChildren = new ObjectArrayList();
        for (Ingredient ing : originalChildren) {
            mapChildren.addAll(MapIngredientTypeManager.getFrom(ing, ItemRecipeCapability.CAP));
        }
        return Collections.singletonList(new IntersectionMapIngredient((List<AbstractMapIngredient>)mapChildren));
    }

    @NotNull
    public static List<AbstractMapIngredient> from(ItemStack stack) {
        MaterialEntry entry = ChemicalHelper.getMaterialEntry((ItemLike)stack.getItem());
        if (!entry.isEmpty() && TagPrefix.ORES.containsKey(entry.tagPrefix())) {
            ArrayList<AbstractMapIngredient> children = new ArrayList<AbstractMapIngredient>();
            children.add(new ItemTagMapIngredient(entry.tagPrefix().getItemTags(entry.material())[0]));
            children.add(new ItemTagMapIngredient(entry.tagPrefix().getItemParentTags()[0]));
            return Collections.singletonList(new IntersectionMapIngredient(children));
        }
        return Collections.emptyList();
    }

    @Override
    protected int hash() {
        int hash = 31;
        for (AbstractMapIngredient child : this.children) {
            hash *= 31 * child.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            IntersectionMapIngredient other = (IntersectionMapIngredient)o;
            if (this.children != null && other.children != null) {
                if (this.children.size() != other.children.size()) {
                    return false;
                }
                for (int i = 0; i < this.children.size(); ++i) {
                    AbstractMapIngredient ingredient2;
                    AbstractMapIngredient ingredient1 = this.children.get(i);
                    if (ingredient1.equals(ingredient2 = other.children.get(i))) continue;
                    return false;
                }
                return true;
            }
        } else if (o instanceof ItemStackMapIngredient) {
            ItemStackMapIngredient stackIngredient = (ItemStackMapIngredient)o;
            for (AbstractMapIngredient child : this.children) {
                if (child.equals(stackIngredient)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isSpecialIngredient() {
        for (AbstractMapIngredient child : this.children) {
            if (!child.isSpecialIngredient()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "IntersectionMapIngredient{children=" + String.valueOf(this.children) + "}";
    }

    @Generated
    public List<AbstractMapIngredient> getChildren() {
        return this.children;
    }
}

