/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ui;

import com.google.common.collect.Table;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.SteamTexture;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.editor.IEditableUI;
import com.gregtechceu.gtceu.api.gui.widget.DualProgressWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.integration.emi.recipe.GTRecipeEMICategory;
import com.gregtechceu.gtceu.integration.jei.recipe.GTRecipeJEICategory;
import com.gregtechceu.gtceu.integration.rei.recipe.GTRecipeREICategory;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import lombok.Generated;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTRecipeTypeUI {
    private Byte2ObjectMap<IGuiTexture> slotOverlays = new Byte2ObjectArrayMap();
    private final GTRecipeType recipeType;
    private ProgressTexture progressBarTexture = new ProgressTexture((IGuiTexture)GuiTextures.PROGRESS_BAR_ARROW.getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)GuiTextures.PROGRESS_BAR_ARROW.getSubTexture(0.0, 0.5, 1.0, 0.5));
    private SteamTexture steamProgressBarTexture = null;
    private ProgressTexture.FillDirection steamMoveType = ProgressTexture.FillDirection.LEFT_TO_RIGHT;
    @Nullable
    protected BiConsumer<GTRecipe, WidgetGroup> uiBuilder;
    protected int maxTooltips = 3;
    private CompoundTag customUICache;
    private Size xeiSize;
    private int originalWidth;

    public GTRecipeTypeUI(@NotNull GTRecipeType recipeType) {
        this.recipeType = recipeType;
    }

    public CompoundTag getCustomUI() {
        if (this.customUICache == null) {
            ResourceManager resourceManager = null;
            if (GTCEu.isClientSide()) {
                resourceManager = Minecraft.getInstance().getResourceManager();
            } else if (GTCEu.getMinecraftServer() != null) {
                resourceManager = GTCEu.getMinecraftServer().getResourceManager();
            }
            if (resourceManager == null) {
                this.customUICache = new CompoundTag();
            } else {
                try {
                    Resource resource = resourceManager.getResourceOrThrow(new ResourceLocation(this.recipeType.registryName.getNamespace(), "ui/recipe_type/%s.rtui".formatted(this.recipeType.registryName.getPath())));
                    try (InputStream inputStream = resource.open();
                         DataInputStream dataInputStream = new DataInputStream(inputStream);){
                        this.customUICache = NbtIo.read((DataInput)dataInputStream, (NbtAccounter)NbtAccounter.UNLIMITED);
                    }
                }
                catch (Exception e) {
                    this.customUICache = new CompoundTag();
                }
                if (this.customUICache == null) {
                    this.customUICache = new CompoundTag();
                }
            }
        }
        return this.customUICache;
    }

    public boolean hasCustomUI() {
        return !this.getCustomUI().isEmpty();
    }

    public void reloadCustomUI() {
        this.customUICache = null;
        this.xeiSize = null;
    }

    public Size getJEISize() {
        Size size = this.xeiSize;
        if (size == null) {
            Size originalSize = this.createEditableUITemplate(false, false).createDefault().getSize();
            this.originalWidth = originalSize.width;
            this.xeiSize = size = new Size(Math.max(this.originalWidth, 150), this.getPropertyHeightShift() + 5 + originalSize.height);
        }
        return size;
    }

    public WidgetGroup createUITemplate(DoubleSupplier progressSupplier, Table<IO, RecipeCapability<?>, Object> storages, CompoundTag data, List<RecipeCondition> conditions, boolean isSteam, boolean isHighPressure) {
        IEditableUI<WidgetGroup, RecipeHolder> template = this.createEditableUITemplate(isSteam, isHighPressure);
        WidgetGroup group = template.createDefault();
        template.setupUI(group, new RecipeHolder(progressSupplier, storages, data, conditions, isSteam, isHighPressure));
        return group;
    }

    public WidgetGroup createUITemplate(DoubleSupplier progressSupplier, Table<IO, RecipeCapability<?>, Object> storages, CompoundTag data, List<RecipeCondition> conditions) {
        return this.createUITemplate(progressSupplier, storages, data, conditions, false, false);
    }

    public IEditableUI<WidgetGroup, RecipeHolder> createEditableUITemplate(boolean isSteam, boolean isHighPressure) {
        return new IEditableUI.Normal<WidgetGroup, RecipeHolder>(() -> {
            boolean isCustomUI;
            boolean bl = isCustomUI = !isSteam && this.hasCustomUI();
            if (isCustomUI) {
                CompoundTag nbt = this.getCustomUI();
                WidgetGroup group = new WidgetGroup();
                IConfigurableWidget.deserializeNBT((IConfigurableWidget)group, (CompoundTag)nbt.getCompound("root"), (Resources)Resources.fromNBT((CompoundTag)nbt.getCompound("resources")), (boolean)false);
                group.setSelfPosition(new Position(0, 0));
                return group;
            }
            WidgetGroup inputs = this.addInventorySlotGroup(false, isSteam, isHighPressure);
            WidgetGroup outputs = this.addInventorySlotGroup(true, isSteam, isHighPressure);
            int maxWidth = Math.max(inputs.getSize().width, outputs.getSize().width);
            WidgetGroup group = new WidgetGroup(0, 0, 2 * maxWidth + 40, Math.max(inputs.getSize().height, outputs.getSize().height));
            Size size = group.getSize();
            inputs.addSelfPosition((maxWidth - inputs.getSize().width) / 2, (size.height - inputs.getSize().height) / 2);
            outputs.addSelfPosition(maxWidth + 40 + (maxWidth - outputs.getSize().width) / 2, (size.height - outputs.getSize().height) / 2);
            group.addWidget((Widget)inputs);
            group.addWidget((Widget)outputs);
            ProgressWidget progressWidget = new ProgressWidget(ProgressWidget.JEIProgress, maxWidth + 10, size.height / 2 - 10, 20, 20, this.progressBarTexture);
            progressWidget.setId("progress");
            group.addWidget((Widget)progressWidget);
            progressWidget.setProgressTexture((IGuiTexture)(isSteam && this.steamProgressBarTexture != null ? new ProgressTexture((IGuiTexture)this.steamProgressBarTexture.get(isHighPressure).getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)this.steamProgressBarTexture.get(isHighPressure).getSubTexture(0.0, 0.5, 1.0, 0.5)).setFillDirection(this.steamMoveType) : this.progressBarTexture));
            return group;
        }, (template, recipeHolder) -> {
            boolean isJEI = recipeHolder.progressSupplier == ProgressWidget.JEIProgress;
            ArrayList progress = new ArrayList();
            WidgetUtils.widgetByIdForEach(template, "^progress$", ProgressWidget.class, progressWidget -> {
                progressWidget.setProgressSupplier(recipeHolder.progressSupplier);
                progress.add(progressWidget);
            });
            WidgetUtils.widgetByIdForEach(template, "^progress$", DualProgressWidget.class, dualProgressWidget -> {
                dualProgressWidget.setProgressSupplier(recipeHolder.progressSupplier);
                progress.add(dualProgressWidget);
            });
            if (!isJEI && (GTCEu.Mods.isREILoaded() || GTCEu.Mods.isJEILoaded() || GTCEu.Mods.isEMILoaded())) {
                for (Widget widget2 : progress) {
                    template.addWidget(new ButtonWidget(widget2.getPosition().x, widget2.getPosition().y, widget2.getSize().width, widget2.getSize().height, IGuiTexture.EMPTY, cd -> {
                        if (cd.isRemote) {
                            if (GTCEu.Mods.isREILoaded()) {
                                ViewSearchBuilder.builder().addCategories((Collection)this.recipeType.getCategories().stream().filter(GTRecipeCategory::isXEIVisible).map(GTRecipeREICategory::machineCategory).collect(Collectors.toList())).open();
                            } else if (GTCEu.Mods.isJEILoaded()) {
                                JEIPlugin.jeiRuntime.getRecipesGui().showTypes(this.recipeType.getCategories().stream().filter(GTRecipeCategory::isXEIVisible).map(GTRecipeJEICategory::machineType).collect(Collectors.toList()));
                            } else if (GTCEu.Mods.isEMILoaded()) {
                                EmiApi.displayRecipeCategory((EmiRecipeCategory)GTRecipeEMICategory.machineCategory(this.recipeType.getCategory()));
                            }
                        }
                    }).setHoverTooltips(new String[]{"gtceu.recipe_type.show_recipes"}));
                }
            }
            for (Map.Entry entry : recipeHolder.storages.rowMap().entrySet()) {
                IO io = (IO)entry.getKey();
                for (Map.Entry storagesEntry : ((Map)entry.getValue()).entrySet()) {
                    RecipeCapability cap = (RecipeCapability)storagesEntry.getKey();
                    Object storage = storagesEntry.getValue();
                    Class<Widget> widgetClass = cap.getWidgetClass();
                    if (widgetClass == null) continue;
                    WidgetUtils.widgetByIdForEach(template, "^%s_[0-9]+$".formatted(cap.slotName(io)), widgetClass, widget -> {
                        int index = WidgetUtils.widgetIdIndex(widget);
                        cap.applyWidgetInfo((Widget)widget, index, isJEI, io, (RecipeHolder)recipeHolder, this.recipeType, null, null, storage, 0, 0);
                    });
                }
            }
        });
    }

    protected WidgetGroup addInventorySlotGroup(boolean isOutputs, boolean isSteam, boolean isHighPressure) {
        int maxCount = 0;
        int totalR = 0;
        Object2IntAVLTreeMap map = new Object2IntAVLTreeMap(RecipeCapability.COMPARATOR);
        if (isOutputs) {
            for (Object2IntMap.Entry value : this.recipeType.maxOutputs.object2IntEntrySet()) {
                if (!((RecipeCapability)value.getKey()).doRenderSlot) continue;
                val = value.getIntValue();
                if (val > maxCount) {
                    maxCount = Math.min(val, 3);
                }
                totalR += (val + 2) / 3;
                map.put((Object)((RecipeCapability)value.getKey()), val);
            }
        } else {
            for (Object2IntMap.Entry value : this.recipeType.maxInputs.object2IntEntrySet()) {
                if (!((RecipeCapability)value.getKey()).doRenderSlot) continue;
                val = value.getIntValue();
                if (val > maxCount) {
                    maxCount = Math.min(val, 3);
                }
                totalR += (val + 2) / 3;
                map.put((Object)((RecipeCapability)value.getKey()), val);
            }
        }
        WidgetGroup group = new WidgetGroup(0, 0, maxCount * 18 + 8, totalR * 18 + 8);
        int index = 0;
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            RecipeCapability cap = (RecipeCapability)entry.getKey();
            Class<Widget> widgetClass = cap.getWidgetClass();
            if (widgetClass == null) continue;
            int capCount = entry.getIntValue();
            for (int slotIndex = 0; slotIndex < capCount; ++slotIndex) {
                Widget slot = cap.createWidget();
                slot.setSelfPosition(new Position(index % 3 * 18 + 4, index / 3 * 18 + 4));
                slot.setBackground(new IGuiTexture[]{this.getOverlaysForSlot(isOutputs, cap, slotIndex == capCount - 1, isSteam, isHighPressure)});
                slot.setId(cap.slotName(isOutputs ? IO.OUT : IO.IN, slotIndex));
                group.addWidget(slot);
                ++index;
            }
            index += (3 - index % 3) % 3;
        }
        return group;
    }

    protected void addSlot(WidgetGroup group, int x, int y, int slotIndex, int count, RecipeCapability<?> capability, boolean isOutputs, boolean isSteam, boolean isHighPressure) {
        if (capability != FluidRecipeCapability.CAP) {
            SlotWidget slot = new SlotWidget();
            slot.initTemplate();
            slot.setSelfPosition(new Position(x, y));
            slot.setBackground(new IGuiTexture[]{this.getOverlaysForSlot(isOutputs, capability, slotIndex == count - 1, isSteam, isHighPressure)});
            slot.setId(ItemRecipeCapability.CAP.slotName(isOutputs ? IO.OUT : IO.IN, slotIndex));
            group.addWidget((Widget)slot);
        } else {
            TankWidget tank = new TankWidget();
            tank.initTemplate();
            tank.setFillDirection(ProgressTexture.FillDirection.ALWAYS_FULL);
            tank.setSelfPosition(new Position(x, y));
            tank.setBackground(this.getOverlaysForSlot(isOutputs, capability, slotIndex == count - 1, isSteam, isHighPressure));
            tank.setId(FluidRecipeCapability.CAP.slotName(isOutputs ? IO.OUT : IO.IN, slotIndex));
            group.addWidget((Widget)tank);
        }
    }

    protected static int[] determineSlotsGrid(int itemCount) {
        int itemSlotsToLeft;
        int itemSlotsToDown;
        double sqrt = Math.sqrt(itemCount);
        if (sqrt % 1.0 == 0.0) {
            itemSlotsToLeft = itemSlotsToDown = (int)sqrt;
        } else if (itemCount == 3) {
            itemSlotsToLeft = 3;
            itemSlotsToDown = 1;
        } else {
            itemSlotsToLeft = (int)Math.ceil(sqrt);
            if (itemCount > itemSlotsToLeft * (itemSlotsToDown = itemSlotsToLeft - 1)) {
                itemSlotsToDown = itemSlotsToLeft;
            }
        }
        return new int[]{itemSlotsToLeft, itemSlotsToDown};
    }

    protected IGuiTexture getOverlaysForSlot(boolean isOutput, RecipeCapability<?> capability, boolean isLast, boolean isSteam, boolean isHighPressure) {
        ResourceBorderTexture base = capability == FluidRecipeCapability.CAP ? GuiTextures.FLUID_SLOT : (isSteam ? GuiTextures.SLOT_STEAM.get(isHighPressure) : GuiTextures.SLOT);
        byte overlayKey = (byte)((isOutput ? 2 : 0) + (capability == FluidRecipeCapability.CAP ? 1 : 0) + (isLast ? 4 : 0));
        if (this.slotOverlays.containsKey(overlayKey)) {
            return new GuiTextureGroup(new IGuiTexture[]{base, (IGuiTexture)this.slotOverlays.get(overlayKey)});
        }
        return base;
    }

    public int getPropertyHeightShift() {
        int maxPropertyCount = this.maxTooltips + this.recipeType.getDataInfos().size() + this.recipeType.getMinRecipeConditions();
        return maxPropertyCount * 10;
    }

    public void appendJEIUI(GTRecipe recipe, WidgetGroup widgetGroup) {
        if (this.uiBuilder != null) {
            this.uiBuilder.accept(recipe, widgetGroup);
        }
    }

    public GTRecipeTypeUI setSlotOverlay(boolean isOutput, boolean isFluid, IGuiTexture slotOverlay) {
        return this.setSlotOverlay(isOutput, isFluid, false, slotOverlay).setSlotOverlay(isOutput, isFluid, true, slotOverlay);
    }

    public GTRecipeTypeUI setSlotOverlay(boolean isOutput, boolean isFluid, boolean isLast, IGuiTexture slotOverlay) {
        this.slotOverlays.put((byte)((isOutput ? 2 : 0) + (isFluid ? 1 : 0) + (isLast ? 4 : 0)), (Object)slotOverlay);
        return this;
    }

    public GTRecipeTypeUI setProgressBar(ResourceTexture progressBar, ProgressTexture.FillDirection moveType) {
        this.progressBarTexture = new ProgressTexture((IGuiTexture)progressBar.getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)progressBar.getSubTexture(0.0, 0.5, 1.0, 0.5)).setFillDirection(moveType);
        return this;
    }

    @Generated
    public Byte2ObjectMap<IGuiTexture> getSlotOverlays() {
        return this.slotOverlays;
    }

    @Generated
    public void setSlotOverlays(Byte2ObjectMap<IGuiTexture> slotOverlays) {
        this.slotOverlays = slotOverlays;
    }

    @Generated
    public ProgressTexture getProgressBarTexture() {
        return this.progressBarTexture;
    }

    @Generated
    public void setProgressBarTexture(ProgressTexture progressBarTexture) {
        this.progressBarTexture = progressBarTexture;
    }

    @Generated
    public void setSteamProgressBarTexture(SteamTexture steamProgressBarTexture) {
        this.steamProgressBarTexture = steamProgressBarTexture;
    }

    @Generated
    public void setSteamMoveType(ProgressTexture.FillDirection steamMoveType) {
        this.steamMoveType = steamMoveType;
    }

    @Generated
    public void setUiBuilder(@Nullable BiConsumer<GTRecipe, WidgetGroup> uiBuilder) {
        this.uiBuilder = uiBuilder;
    }

    @Generated
    public void setMaxTooltips(int maxTooltips) {
        this.maxTooltips = maxTooltips;
    }

    @Generated
    public int getMaxTooltips() {
        return this.maxTooltips;
    }

    @Generated
    public int getOriginalWidth() {
        return this.originalWidth;
    }

    public record RecipeHolder(DoubleSupplier progressSupplier, Table<IO, RecipeCapability<?>, Object> storages, CompoundTag data, List<RecipeCondition> conditions, boolean isSteam, boolean isHighPressure) {
    }
}

