/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.transfer.fluid;

import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class CustomFluidTank
extends FluidTank
implements IFluidHandlerModifiable,
ITagSerializable<CompoundTag>,
IContentChangeAware {
    @NotNull
    protected Runnable onContentsChanged;

    public CustomFluidTank(int capacity) {
        super(capacity, e -> true);
        this.onContentsChanged = () -> {};
    }

    public CustomFluidTank(int capacity, Predicate<FluidStack> validator) {
        super(capacity, validator);
        this.onContentsChanged = () -> {};
    }

    public CustomFluidTank(FluidStack stack) {
        super(stack.getAmount());
        this.onContentsChanged = () -> {};
        this.setFluid(stack);
    }

    protected void onContentsChanged() {
        this.onContentsChanged.run();
    }

    @Override
    public void setFluidInTank(int tank, FluidStack stack) {
        this.setFluid(stack);
    }

    public void setFluid(FluidStack stack) {
        super.setFluid(stack);
        this.onContentsChanged();
    }

    public CompoundTag serializeNBT() {
        return this.writeToNBT(new CompoundTag());
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.readFromNBT(nbt);
    }

    @NotNull
    @Generated
    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    @Generated
    public void setOnContentsChanged(@NotNull Runnable onContentsChanged) {
        if (onContentsChanged == null) {
            throw new NullPointerException("onContentsChanged is marked non-null but is null");
        }
        this.onContentsChanged = onContentsChanged;
    }
}

