/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.transfer.fluid;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidHandlerList
implements IFluidHandlerModifiable,
INBTSerializable<CompoundTag> {
    public final IFluidHandler[] handlers;
    protected Predicate<FluidStack> filter = fluid -> true;

    public FluidHandlerList(IFluidHandler ... handlers) {
        this.handlers = handlers;
    }

    public FluidHandlerList(List<IFluidHandler> handlers) {
        this.handlers = (IFluidHandler[])handlers.toArray(IFluidHandler[]::new);
    }

    public int getTanks() {
        return Arrays.stream(this.handlers).mapToInt(IFluidHandler::getTanks).sum();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        int index = 0;
        for (IFluidHandler handler : this.handlers) {
            if (tank - index < handler.getTanks()) {
                return handler.getFluidInTank(tank - index);
            }
            index += handler.getTanks();
        }
        return FluidStack.EMPTY;
    }

    @Override
    public void setFluidInTank(int tank, FluidStack stack) {
        int index = 0;
        for (IFluidHandler handler : this.handlers) {
            IFluidHandlerModifiable modifiable;
            if (handler instanceof IFluidHandlerModifiable && tank - index < (modifiable = (IFluidHandlerModifiable)handler).getTanks()) {
                modifiable.setFluidInTank(tank - index, stack);
                return;
            }
            index += handler.getTanks();
        }
    }

    public int getTankCapacity(int tank) {
        int index = 0;
        for (IFluidHandler handler : this.handlers) {
            if (tank - index < handler.getTanks()) {
                return handler.getTankCapacity(tank - index);
            }
            index += handler.getTanks();
        }
        return 0;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        if (!this.filter.test(stack)) {
            return false;
        }
        int index = 0;
        for (IFluidHandler handler : this.handlers) {
            if (tank - index < handler.getTanks()) {
                return handler.isFluidValid(tank - index, stack);
            }
            index += handler.getTanks();
        }
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.filter.test(resource)) {
            return 0;
        }
        FluidStack copied = resource.copy();
        for (IFluidHandler handler : this.handlers) {
            FluidStack candidate = copied.copy();
            copied.shrink(handler.fill(candidate, action));
            if (copied.isEmpty()) break;
        }
        return resource.getAmount() - copied.getAmount();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.filter.test(resource)) {
            return FluidStack.EMPTY;
        }
        FluidStack copied = resource.copy();
        for (IFluidHandler handler : this.handlers) {
            FluidStack candidate = copied.copy();
            copied.shrink(handler.drain(candidate, action).getAmount());
            if (copied.isEmpty()) break;
        }
        copied.setAmount(resource.getAmount() - copied.getAmount());
        return copied;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack totalDrained = null;
        for (IFluidHandler handler : this.handlers) {
            if (totalDrained == null || totalDrained.isEmpty()) {
                totalDrained = handler.drain(maxDrain, action);
                if (totalDrained.isEmpty()) {
                    totalDrained = null;
                } else {
                    maxDrain -= totalDrained.getAmount();
                }
            } else {
                FluidStack copy = totalDrained.copy();
                copy.setAmount(maxDrain);
                FluidStack drain = handler.drain(copy, action);
                totalDrained.grow(drain.getAmount());
                maxDrain -= drain.getAmount();
            }
            if (maxDrain <= 0) break;
        }
        return totalDrained == null ? FluidStack.EMPTY : totalDrained;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (IFluidHandler handler : this.handlers) {
            if (handler instanceof INBTSerializable) {
                INBTSerializable serializable = (INBTSerializable)handler;
                list.add((Object)serializable.serializeNBT());
                continue;
            }
            GTCEu.LOGGER.warn("[FluidHandlerList] internal tank doesn't support serialization");
        }
        tag.put("tanks", (Tag)list);
        tag.putByte("type", list.getElementType());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag list = nbt.getList("tanks", (int)nbt.getByte("type"));
        for (int i = 0; i < list.size(); ++i) {
            IFluidHandler iFluidHandler = this.handlers[i];
            if (iFluidHandler instanceof INBTSerializable) {
                INBTSerializable serializable = (INBTSerializable)iFluidHandler;
                serializable.deserializeNBT(list.get(i));
                continue;
            }
            GTCEu.LOGGER.warn("[FluidHandlerList] internal tank doesn't support serialization");
        }
    }

    @Override
    public boolean supportsFill(int tank) {
        for (IFluidHandler handler : this.handlers) {
            if (tank >= handler.getTanks()) {
                tank -= handler.getTanks();
                continue;
            }
            if (!(handler instanceof IFluidHandlerModifiable)) continue;
            IFluidHandlerModifiable modifiable = (IFluidHandlerModifiable)handler;
            return modifiable.supportsFill(tank);
        }
        return true;
    }

    @Override
    public boolean supportsDrain(int tank) {
        for (IFluidHandler handler : this.handlers) {
            if (tank >= handler.getTanks()) {
                tank -= handler.getTanks();
                continue;
            }
            if (!(handler instanceof IFluidHandlerModifiable)) continue;
            IFluidHandlerModifiable modifiable = (IFluidHandlerModifiable)handler;
            return modifiable.supportsDrain(tank);
        }
        return true;
    }

    @Generated
    public void setFilter(Predicate<FluidStack> filter) {
        this.filter = filter;
    }
}

