/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client;

import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorComponentItem;
import com.gregtechceu.gtceu.api.item.armor.IArmorLogic;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IItemHUDProvider;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.jetbrains.annotations.NotNull;

public class HudGuiOverlay
implements IGuiOverlay {
    public void render(ForgeGui forgeGui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.isWindowActive() && mc.level != null && !mc.options.renderDebug && !mc.options.hideGui) {
            HudGuiOverlay.renderHUDMetaArmor(mc.player.getItemBySlot(EquipmentSlot.HEAD), guiGraphics);
            HudGuiOverlay.renderHUDMetaArmor(mc.player.getItemBySlot(EquipmentSlot.CHEST), guiGraphics);
            HudGuiOverlay.renderHUDMetaArmor(mc.player.getItemBySlot(EquipmentSlot.LEGS), guiGraphics);
            HudGuiOverlay.renderHUDMetaArmor(mc.player.getItemBySlot(EquipmentSlot.FEET), guiGraphics);
            HudGuiOverlay.renderHUDMetaItem(mc.player.getItemInHand(InteractionHand.MAIN_HAND), guiGraphics);
            HudGuiOverlay.renderHUDMetaItem(mc.player.getItemInHand(InteractionHand.OFF_HAND), guiGraphics);
        }
    }

    private static void renderHUDMetaArmor(@NotNull ItemStack stack, GuiGraphics guiGraphics) {
        ArmorComponentItem valueItem;
        IArmorLogic iArmorLogic;
        Item item = stack.getItem();
        if (item instanceof ArmorComponentItem && (iArmorLogic = (valueItem = (ArmorComponentItem)item).getArmorLogic()) instanceof IItemHUDProvider) {
            IItemHUDProvider provider = (IItemHUDProvider)((Object)iArmorLogic);
            IItemHUDProvider.tryDrawHud(provider, stack, guiGraphics);
        }
    }

    private static void renderHUDMetaItem(@NotNull ItemStack stack, GuiGraphics guiGraphics) {
        Item item = stack.getItem();
        if (item instanceof ComponentItem) {
            ComponentItem valueItem = (ComponentItem)item;
            for (IItemComponent behaviour : valueItem.getComponents()) {
                if (!(behaviour instanceof IItemHUDProvider)) continue;
                IItemHUDProvider provider = (IItemHUDProvider)behaviour;
                IItemHUDProvider.tryDrawHud(provider, stack, guiGraphics);
            }
        }
    }

    @Generated
    public HudGuiOverlay() {
    }
}

