/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine.overlays;

import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.registry.registrate.provider.GTBlockstateProvider;
import com.gregtechceu.gtceu.common.data.models.GTModels;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HPCAOverlay {
    public static final HPCAOverlay EMPTY = new HPCAOverlay();
    private final Map<RecipeLogic.Status, ResourceLocation> textures = new EnumMap<RecipeLogic.Status, ResourceLocation>(RecipeLogic.Status.class);
    private final Map<RecipeLogic.Status, ResourceLocation> emissiveTextures = new EnumMap<RecipeLogic.Status, ResourceLocation>(RecipeLogic.Status.class);

    public static HPCAOverlay get(ResourceLocation normalSprite, ResourceLocation damagedSprite, ExistingFileHelper fileHelper) {
        ResourceLocation damagedActiveSpriteEmissive;
        ResourceLocation damagedSpriteEmissive;
        ResourceLocation activeSpriteEmissive;
        ResourceLocation normalSpriteEmissive;
        ResourceLocation damagedActiveSprite;
        if (!fileHelper.exists(normalSprite, (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
            return EMPTY;
        }
        ResourceLocation activeSprite = normalSprite.withSuffix("_active");
        if (!fileHelper.exists(activeSprite, (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
            activeSprite = normalSprite;
        }
        if (!fileHelper.exists(damagedActiveSprite = damagedSprite.withSuffix("_active"), (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
            damagedActiveSprite = damagedSprite;
        }
        if (!fileHelper.exists(normalSpriteEmissive = normalSprite.withSuffix("_emissive"), (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
            normalSpriteEmissive = null;
        }
        if (!fileHelper.exists(activeSpriteEmissive = activeSprite.withSuffix("_emissive"), (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
            activeSpriteEmissive = null;
        }
        if (!fileHelper.exists(damagedSpriteEmissive = damagedSprite.withSuffix("_emissive"), (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
            damagedSpriteEmissive = null;
        }
        if (!fileHelper.exists(damagedActiveSpriteEmissive = damagedActiveSprite.withSuffix("_emissive"), (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
            damagedActiveSpriteEmissive = null;
        }
        return new HPCAOverlay(normalSprite, activeSprite, damagedSprite, damagedActiveSprite, normalSpriteEmissive, activeSpriteEmissive, damagedSpriteEmissive, damagedActiveSpriteEmissive);
    }

    public HPCAOverlay(@Nullable ResourceLocation normalSprite, @Nullable ResourceLocation activeSprite, @Nullable ResourceLocation damagedSprite, @Nullable ResourceLocation damagedActiveSprite, @Nullable ResourceLocation normalSpriteEmissive, @Nullable ResourceLocation activeSpriteEmissive, @Nullable ResourceLocation damagedSpriteEmissive, @Nullable ResourceLocation damagedActiveSpriteEmissive) {
        this.textures.put(RecipeLogic.Status.IDLE, normalSprite);
        this.emissiveTextures.put(RecipeLogic.Status.IDLE, normalSpriteEmissive);
        this.textures.put(RecipeLogic.Status.WORKING, activeSprite);
        this.emissiveTextures.put(RecipeLogic.Status.WORKING, activeSpriteEmissive);
        this.textures.put(RecipeLogic.Status.WAITING, damagedActiveSprite);
        this.emissiveTextures.put(RecipeLogic.Status.WAITING, damagedActiveSpriteEmissive);
        this.textures.put(RecipeLogic.Status.SUSPEND, damagedSprite);
        this.emissiveTextures.put(RecipeLogic.Status.SUSPEND, damagedSpriteEmissive);
    }

    private HPCAOverlay() {
    }

    private static RecipeLogic.Status getStatus(boolean active, boolean damaged) {
        if (damaged && active) {
            return RecipeLogic.Status.WAITING;
        }
        if (damaged) {
            return RecipeLogic.Status.SUSPEND;
        }
        if (active) {
            return RecipeLogic.Status.WORKING;
        }
        return RecipeLogic.Status.IDLE;
    }

    @NotNull
    public ResourceLocation getTexture(boolean active, boolean damaged) {
        ResourceLocation value = this.textures.get((Object)HPCAOverlay.getStatus(active, damaged));
        return value != null ? value : GTModels.BLANK_TEXTURE;
    }

    @NotNull
    public ResourceLocation getEmissiveTexture(boolean active, boolean damaged) {
        ResourceLocation value = this.emissiveTextures.get((Object)HPCAOverlay.getStatus(active, damaged));
        return value != null ? value : GTModels.BLANK_TEXTURE;
    }
}

