/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SurfaceRockRenderer {
    private static final Set<SurfaceRockRenderer> MODELS = new HashSet<SurfaceRockRenderer>();
    private final Block block;

    public static void create(Block block) {
        MODELS.add(new SurfaceRockRenderer(block));
    }

    public static void reinitModels() {
        for (SurfaceRockRenderer model : MODELS) {
            ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)model.block);
            ResourceLocation modelId = blockId.withPrefix("block/");
            GTDynamicResourcePack.addBlockModel(blockId, (Supplier<JsonElement>)new DelegatedModel(GTCEu.id("block/surface_rock")));
            GTDynamicResourcePack.addBlockState(blockId, (Supplier<JsonElement>)MultiVariantGenerator.multiVariant((Block)model.block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)modelId)).with((PropertyDispatch)PropertyDispatch.property((Property)BlockStateProperties.FACING).select((Comparable)Direction.DOWN, Variant.variant()).select((Comparable)Direction.UP, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90))));
            GTDynamicResourcePack.addItemModel(blockId, (Supplier<JsonElement>)new DelegatedModel(modelId));
        }
    }

    protected SurfaceRockRenderer(Block block) {
        this.block = block;
    }
}

