/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.cover;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.machine.MachineCoverContainer;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.cover.IDynamicCoverRenderer;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ICoverableRenderer {
    @OnlyIn(value=Dist.CLIENT)
    public static final TextureAtlasSprite[] COVER_BACK_PLATE = new TextureAtlasSprite[1];

    @OnlyIn(value=Dist.CLIENT)
    public static void initSprites(TextureAtlas atlas) {
        ICoverableRenderer.COVER_BACK_PLATE[0] = atlas.getSprite(GTCEu.id("block/material_sets/dull/wire_side"));
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderCovers(List<BakedQuad> quads, @NotNull ICoverable coverable, BlockPos pos, BlockAndTintGetter level, @Nullable Direction side, RandomSource rand, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        double thickness = coverable.getCoverPlateThickness();
        for (Direction face : GTUtil.DIRECTIONS) {
            CoverBehavior cover = coverable.getCoverAtSide(face);
            if (cover == null) continue;
            if (thickness > 0.0 && cover.shouldRenderPlate()) {
                double min = thickness + 0.01;
                double max = 0.99 - thickness;
                Vec3i normal = face.getNormal();
                AABB cube = new AABB(normal.getX() > 0 ? max : 0.01, normal.getY() > 0 ? max : 0.01, normal.getZ() > 0 ? max : 0.01, normal.getX() >= 0 ? 0.99 : min, normal.getY() >= 0 ? 0.99 : min, normal.getZ() >= 0 ? 0.99 : min);
                if (side == null) {
                    quads.add(FaceQuad.builder((Direction)face.getOpposite(), (TextureAtlasSprite)COVER_BACK_PLATE[0]).cube(cube).cubeUV().bake());
                } else if (side != face.getOpposite()) {
                    quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)COVER_BACK_PLATE[0]).cube(cube).cubeUV().bake());
                }
            }
            cover.getCoverRenderer().get().renderCover(quads, side, rand, cover, pos, level, modelData, renderType);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void renderDynamicCovers(MetaMachine machine, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        MachineCoverContainer coverable = machine.getCoverContainer();
        for (Direction face : GTUtil.DIRECTIONS) {
            IDynamicCoverRenderer renderer;
            CoverBehavior cover = coverable.getCoverAtSide(face);
            IDynamicCoverRenderer iDynamicCoverRenderer = renderer = cover != null ? cover.getDynamicRenderer().get() : null;
            if (renderer == null) continue;
            poseStack.pushPose();
            RenderUtil.moveToFace(poseStack, 0.5f, 0.5f, 0.5f, face);
            RenderUtil.rotateToFace(poseStack, face, Direction.NORTH);
            poseStack.translate(-0.5f, -0.5f, 0.01f);
            renderer.render(machine, face, partialTick, poseStack, buffer, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }
}

