/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.item;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class TagPrefixItemRenderer {
    private static final Set<TagPrefixItemRenderer> MODELS = new HashSet<TagPrefixItemRenderer>();
    private final Item item;
    private final MaterialIconType type;
    private final MaterialIconSet iconSet;

    public static void create(Item item, MaterialIconType type, MaterialIconSet iconSet) {
        MODELS.add(new TagPrefixItemRenderer(item, type, iconSet));
    }

    public static void reinitModels() {
        for (TagPrefixItemRenderer model : MODELS) {
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)model.item);
            GTDynamicResourcePack.addItemModel(itemId, (Supplier<JsonElement>)new DelegatedModel(model.type.getItemModelPath(model.iconSet, true)));
        }
    }

    private TagPrefixItemRenderer(Item item, MaterialIconType type, MaterialIconSet iconSet) {
        this.item = item;
        this.type = type;
        this.iconSet = iconSet;
    }
}

