/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRenderType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.function.BinaryOperator;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class DynamicRenderManager {
    public static final BinaryOperator<String> MODEL_ID_FORMATTER = (arg_0, arg_1) -> DynamicRenderManager.lambda$static$0("/block/machine/%s/dynamic_render/%s", arg_0, arg_1);
    public static final Codec<DynamicRenderType<?, ?>> TYPE_CODEC = ResourceLocation.CODEC.flatXmap(id -> {
        DynamicRenderType type = DynamicRenderManager.getType(id);
        if (type != null) {
            return DataResult.success(type);
        }
        return DataResult.error(() -> "Dynamic render type with ID " + String.valueOf(id) + " does not exist");
    }, type -> {
        ResourceLocation id = DynamicRenderManager.getId(type);
        if (id != null) {
            return DataResult.success((Object)id);
        }
        return DataResult.error(() -> "Dynamic render type " + String.valueOf(type) + " is not registered");
    });
    private static final BiMap<ResourceLocation, DynamicRenderType<?, ?>> DYNAMIC_RENDERER_TYPES = HashBiMap.create((int)5);

    public static <T extends IMachineFeature, S extends DynamicRender<T, S>> DynamicRenderType<T, S> register(ResourceLocation id, DynamicRenderType<T, S> type) {
        if (DYNAMIC_RENDERER_TYPES.containsKey((Object)id)) {
            throw new IllegalArgumentException("Cannot register multiple dynamic render types with the same id! Tried " + String.valueOf(id));
        }
        DYNAMIC_RENDERER_TYPES.put((Object)id, type);
        return type;
    }

    @Nullable
    public static <T extends IMachineFeature, S extends DynamicRender<T, S>> DynamicRenderType<T, S> getType(ResourceLocation id) {
        return (DynamicRenderType)DYNAMIC_RENDERER_TYPES.get((Object)id);
    }

    @Nullable
    public static ResourceLocation getId(DynamicRenderType<?, ?> type) {
        return (ResourceLocation)DYNAMIC_RENDERER_TYPES.inverse().get(type);
    }

    private DynamicRenderManager() {
    }

    private static /* synthetic */ String lambda$static$0(String rec$, Object xva$0, Object xva$1) {
        return "/block/machine/%s/dynamic_render/%s".formatted(xva$0, xva$1);
    }
}

