/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine.impl;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRenderType;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.machine.storage.CreativeChestMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTMatrixUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class QuantumChestItemRender
extends DynamicRender<QuantumChestMachine, QuantumChestItemRender> {
    public static final Codec<QuantumChestItemRender> CODEC = Codec.unit(QuantumChestItemRender::new);
    public static final DynamicRenderType<QuantumChestMachine, QuantumChestItemRender> TYPE = new DynamicRenderType(CODEC);
    @Nullable
    private static Item CREATIVE_CHEST_ITEM = null;

    @Override
    public DynamicRenderType<QuantumChestMachine, QuantumChestItemRender> getType() {
        return TYPE;
    }

    @Override
    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (CREATIVE_CHEST_ITEM == null) {
            CREATIVE_CHEST_ITEM = GTMachines.CREATIVE_ITEM.getItem();
        }
        if (stack.hasTag()) {
            poseStack.pushPose();
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            ItemStack itemStack = ItemStack.of((CompoundTag)stack.getOrCreateTagElement("stored"));
            long storedAmount = stack.getOrCreateTag().getLong("storedAmount");
            float totalTick = (float)Minecraft.getInstance().level.getGameTime() + Minecraft.getInstance().getFrameTime();
            this.renderChestItem(poseStack, buffer, totalTick, Direction.NORTH, itemStack, storedAmount, ItemStack.EMPTY, stack.is(CREATIVE_CHEST_ITEM));
            poseStack.popPose();
        }
        super.renderByItem(stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
    }

    @Override
    public void render(QuantumChestMachine machine, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        QuantumChestItemRender.setupModelRotation(machine, poseStack);
        float totalTick = (float)machine.getLevel().getGameTime() + partialTick;
        this.renderChestItem(poseStack, buffer, totalTick, machine.getFrontFacing(), machine.getStored(), machine.getStoredAmount(), machine.getLockedItem(), machine instanceof CreativeChestMachine);
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderChestItem(PoseStack poseStack, MultiBufferSource buffer, float totalTick, Direction frontFacing, ItemStack stored, long storedAmount, ItemStack locked, boolean isCreative) {
        ItemStack itemStack;
        ItemStack itemStack2 = itemStack = !stored.isEmpty() ? stored : locked;
        if (itemStack.isEmpty()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        if (frontFacing.getAxis() == Direction.Axis.Y) {
            Quaternionf rotation = GTMatrixUtils.getRotation(Direction.NORTH, frontFacing);
            poseStack.mulPose(rotation);
        }
        poseStack.mulPose(new Quaternionf().rotateY(totalTick * ((float)Math.PI * 2) / 80.0f));
        poseStack.scale(0.6f, 0.6f, 0.6f);
        itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, poseStack, buffer, (Level)Minecraft.getInstance().level, Item.getId((Item)itemStack.getItem()) + itemStack.getDamageValue());
        poseStack.popPose();
        QuantumChestItemRender.drawAmountText(poseStack, buffer, frontFacing, storedAmount, isCreative);
    }

    public static void setupModelRotation(MetaMachine machine, PoseStack poseStack) {
        Direction frontFacing = machine.getFrontFacing();
        Direction upwardFacing = machine.getUpwardsFacing();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        GTMatrixUtils.rotateMatrix(poseStack.last().pose(), GTMatrixUtils.upwardFacingAngle(upwardFacing) + (upwardFacing.getAxis() == Direction.Axis.X ? (float)Math.PI : 0.0f), GTMatrixUtils.getDirectionAxis(frontFacing), new Vector3f[0]);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
    }

    public static void drawAmountText(PoseStack poseStack, MultiBufferSource buffer, Direction frontFacing, long storedAmount, boolean isCreative) {
        String text;
        poseStack.pushPose();
        RenderSystem.disableDepthTest();
        poseStack.translate((float)(frontFacing.getStepX() * -1) / 16.0f, (float)(frontFacing.getStepY() * -1) / 16.0f, (float)(frontFacing.getStepZ() * -1) / 16.0f);
        RenderUtil.moveToFace(poseStack, 0.5f, 0.5f, 0.5f, frontFacing);
        RenderUtil.rotateToFace(poseStack, frontFacing, Direction.NORTH);
        poseStack.scale(0.015625f, 0.015625f, 0.0f);
        poseStack.translate(-32.0f, -32.0f, 0.0f);
        boolean x = false;
        int y = 24;
        int w = 64;
        int h = 28;
        float textX = (float)x + (float)w / 2.0f;
        float textY = (float)y + (float)h / 2.0f;
        poseStack.pushPose();
        if (isCreative) {
            text = "\u221e";
            poseStack.translate(textX, textY, 0.0f);
            poseStack.scale(3.0f, 3.0f, 1.0f);
            poseStack.translate(-textX, -textY, 0.0f);
        } else {
            text = storedAmount <= 0L ? "*" : FormattingUtil.formatNumberReadable(storedAmount, false);
        }
        Font font = Minecraft.getInstance().font;
        float f = textX - font.getSplitter().stringWidth(text) / 2.0f;
        Objects.requireNonNull(font);
        font.drawInBatch(text, f, textY - 9.0f / 2.0f, -1, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
        RenderSystem.enableDepthTest();
        poseStack.popPose();
    }
}

