/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine.impl;

import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRenderType;
import com.gregtechceu.gtceu.client.renderer.machine.impl.QuantumChestItemRender;
import com.gregtechceu.gtceu.client.util.RenderBufferHelper;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.machine.storage.CreativeTankMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumTankMachine;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.Codec;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class QuantumTankFluidRender
extends DynamicRender<QuantumTankMachine, QuantumTankFluidRender> {
    public static final Codec<QuantumTankFluidRender> CODEC = Codec.unit(QuantumTankFluidRender::new);
    public static final DynamicRenderType<QuantumTankMachine, QuantumTankFluidRender> TYPE = new DynamicRenderType(CODEC);
    private static final float MIN = 0.16f;
    private static final float MAX = 0.84f;
    @Nullable
    private static Item CREATIVE_FLUID_ITEM = null;

    @Override
    public DynamicRenderType<QuantumTankMachine, QuantumTankFluidRender> getType() {
        return TYPE;
    }

    @Override
    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (CREATIVE_FLUID_ITEM == null) {
            CREATIVE_FLUID_ITEM = GTMachines.CREATIVE_FLUID.getItem();
        }
        if (stack.hasTag()) {
            poseStack.pushPose();
            FluidStack stored = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.getOrCreateTagElement("stored"));
            long storedAmount = stack.getOrCreateTag().getLong("storedAmount");
            if (storedAmount == 0L && !stored.isEmpty()) {
                storedAmount = stored.getAmount();
            }
            long maxAmount = 0L;
            Item item = stack.getItem();
            if (item instanceof MetaMachineItem) {
                MetaMachineItem machineItem = (MetaMachineItem)item;
                maxAmount = QuantumTankMachine.TANK_CAPACITY.getLong((Object)machineItem.getDefinition());
            }
            this.renderTank(poseStack, buffer, Direction.NORTH, stored, storedAmount, maxAmount, FluidStack.EMPTY, stack.is(CREATIVE_FLUID_ITEM));
            poseStack.popPose();
        }
        super.renderByItem(stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
    }

    @Override
    public void render(QuantumTankMachine machine, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        QuantumChestItemRender.setupModelRotation(machine, poseStack);
        this.renderTank(poseStack, buffer, machine.getFrontFacing(), machine.getStored(), machine.getStoredAmount(), machine.getMaxAmount(), machine.getLockedFluid(), machine instanceof CreativeTankMachine);
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTank(PoseStack poseStack, MultiBufferSource buffer, Direction frontFacing, FluidStack stored, long storedAmount, long maxAmount, FluidStack locked, boolean isCreative) {
        float maxZ;
        float minZ;
        float maxY;
        float minY;
        float minBot;
        FluidStack fluid;
        FluidStack fluidStack = fluid = !stored.isEmpty() ? stored : locked;
        if (fluid.isEmpty()) {
            return;
        }
        IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        TextureAtlasSprite fluidSprite = RenderUtil.FluidTextureType.STILL.map(ext, fluid);
        EnumSet<Direction> sidesToRender = EnumSet.of(frontFacing);
        VertexConsumer builder = buffer.getBuffer(Sheets.translucentCullBlockSheet());
        boolean gas = fluid.getFluid().getFluidType().isLighterThanAir();
        float percentFull = isCreative || maxAmount <= storedAmount ? 1.0f : (float)storedAmount / (float)maxAmount;
        float maxTop = gas ? 0.84f : 0.16f + percentFull * 0.67999995f;
        float f = minBot = gas ? 0.16f + (1.0f - percentFull) * 0.67999995f : 0.16f;
        if (frontFacing.getAxis() == Direction.Axis.Y) {
            minY = 0.16f;
            maxY = 0.84f;
            if (frontFacing == Direction.UP) {
                minZ = minBot;
                maxZ = maxTop;
                sidesToRender.add(gas ? Direction.SOUTH : Direction.NORTH);
            } else {
                minZ = 1.0f - maxTop;
                maxZ = 1.0f - minBot;
                sidesToRender.add(gas ? Direction.NORTH : Direction.SOUTH);
            }
        } else {
            minY = minBot;
            maxY = maxTop;
            minZ = 0.16f;
            maxZ = 0.84f;
            sidesToRender.add(gas ? Direction.DOWN : Direction.UP);
        }
        RenderBufferHelper.renderCube(builder, poseStack.last(), sidesToRender, ext.getTintColor(fluid) | 0xFF000000, 0xF000F0, fluidSprite, 0.16f, minY, minZ, 0.84f, maxY, maxZ);
        QuantumChestItemRender.drawAmountText(poseStack, buffer, frontFacing, storedAmount, isCreative);
    }
}

