/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IHazardParticleContainer;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IEnvironmentalHazardCleaner;
import com.gregtechceu.gtceu.api.machine.feature.IEnvironmentalHazardEmitter;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctNetHandler;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctPipeNet;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctPipeType;
import com.gregtechceu.gtceu.common.pipelike.duct.LevelDuctPipeNet;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuctPipeBlockEntity
extends PipeBlockEntity<DuctPipeType, DuctPipeProperties> {
    protected final EnumMap<Direction, DuctNetHandler> handlers = new EnumMap(Direction.class);
    public final IHazardParticleContainer clientCapability = new DefaultDuctContainer();
    private WeakReference<DuctPipeNet> currentPipeNet = new WeakReference<Object>(null);
    protected DuctNetHandler defaultHandler;

    protected DuctPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static DuctPipeBlockEntity create(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new DuctPipeBlockEntity(type, pos, blockState);
    }

    public static void onBlockEntityRegister(BlockEntityType<DuctPipeBlockEntity> ductBlockEntityBlockEntityType) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == GTCapability.CAPABILITY_HAZARD_CONTAINER) {
            if (this.getLevel().isClientSide()) {
                return GTCapability.CAPABILITY_HAZARD_CONTAINER.orEmpty(cap, LazyOptional.of(() -> this.clientCapability));
            }
            if (this.handlers.isEmpty()) {
                this.initHandlers();
            }
            this.checkNetwork();
            return GTCapability.CAPABILITY_HAZARD_CONTAINER.orEmpty(cap, LazyOptional.of(() -> this.handlers.getOrDefault(side, this.defaultHandler)));
        }
        if (cap == GTCapability.CAPABILITY_COVERABLE) {
            return GTCapability.CAPABILITY_COVERABLE.orEmpty(cap, LazyOptional.of(this::getCoverContainer));
        }
        if (cap == GTCapability.CAPABILITY_TOOLABLE) {
            return GTCapability.CAPABILITY_TOOLABLE.orEmpty(cap, LazyOptional.of(() -> this));
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canHaveBlockedFaces() {
        return false;
    }

    public void initHandlers() {
        DuctPipeNet net = this.getDuctPipeNet();
        if (net == null) {
            return;
        }
        for (Direction facing : GTUtil.DIRECTIONS) {
            this.handlers.put(facing, new DuctNetHandler(net, this, facing));
        }
        this.defaultHandler = new DuctNetHandler(net, this, null);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            DuctPipeNet current = this.getDuctPipeNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (DuctNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    public DuctPipeNet getDuctPipeNet() {
        if (this.level == null || this.level.isClientSide) {
            return null;
        }
        DuctPipeNet currentPipeNet = (DuctPipeNet)this.currentPipeNet.get();
        if (currentPipeNet != null && currentPipeNet.isValid() && currentPipeNet.containsNode(this.getPipePos())) {
            return currentPipeNet;
        }
        LevelDuctPipeNet worldNet = (LevelDuctPipeNet)((Object)this.getPipeBlock().getWorldPipeNet((ServerLevel)this.getPipeLevel()));
        currentPipeNet = (DuctPipeNet)worldNet.getNetFromPos(this.getPipePos());
        if (currentPipeNet != null) {
            this.currentPipeNet = new WeakReference<DuctPipeNet>(currentPipeNet);
        }
        return currentPipeNet;
    }

    @Override
    public boolean canAttachTo(Direction side) {
        if (this.level != null) {
            IMachineBlockEntity machineBlockEntity;
            BlockEntity blockEntity;
            if (this.level.getBlockEntity(this.getBlockPos().relative(side)) instanceof DuctPipeBlockEntity) {
                return false;
            }
            BlockPos relative = this.getBlockPos().relative(side);
            return GTCapabilityHelper.getHazardContainer(this.level, relative, side.getOpposite()) != null || (blockEntity = this.level.getBlockEntity(relative)) instanceof IMachineBlockEntity && ((machineBlockEntity = (IMachineBlockEntity)blockEntity).getMetaMachine() instanceof IEnvironmentalHazardCleaner || machineBlockEntity.getMetaMachine() instanceof IEnvironmentalHazardEmitter);
        }
        return false;
    }

    @Generated
    public EnumMap<Direction, DuctNetHandler> getHandlers() {
        return this.handlers;
    }

    @Generated
    public DuctNetHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    private static class DefaultDuctContainer
    implements IHazardParticleContainer {
        private DefaultDuctContainer() {
        }

        @Override
        public boolean inputsHazard(Direction side, MedicalCondition condition) {
            return false;
        }

        @Override
        public float changeHazard(MedicalCondition condition, float differenceAmount) {
            return 0.0f;
        }

        @Override
        public float getHazardStored(MedicalCondition condition) {
            return 0.0f;
        }

        @Override
        public float getHazardCapacity(MedicalCondition condition) {
            return 0.0f;
        }
    }
}

