/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.common.block.ItemPipeBlock;
import com.gregtechceu.gtceu.common.pipelike.item.ItemNetHandler;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeNet;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeType;
import com.gregtechceu.gtceu.utils.FacingPos;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemPipeBlockEntity
extends PipeBlockEntity<ItemPipeType, ItemPipeProperties> {
    protected WeakReference<ItemPipeNet> currentItemPipeNet = new WeakReference<Object>(null);
    protected boolean hasCurrentNetChanged = false;
    private final EnumMap<Direction, ItemNetHandler> handlers = new EnumMap(Direction.class);
    private final Object2IntMap<FacingPos> transferred = new Object2IntOpenHashMap();
    private int transferredItems = 0;
    private long timer = 0L;

    public ItemPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static ItemPipeBlockEntity create(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        return new ItemPipeBlockEntity(type, pos, blockState);
    }

    public long getLevelTime() {
        return this.hasLevel() ? Objects.requireNonNull(this.getLevel()).getGameTime() : 0L;
    }

    public static void onBlockEntityRegister(BlockEntityType<ItemPipeBlockEntity> itemPipeBlockEntityBlockEntityType) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            Level world = this.getLevel();
            if (world == null || world.isClientSide()) {
                return LazyOptional.empty();
            }
            if (side != null && this.isConnected(side)) {
                this.ensureHandlersInitialized();
                this.checkNetwork();
                if (this.currentItemPipeNet.get() == null) {
                    return LazyOptional.empty();
                }
                return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, LazyOptional.of(() -> this.getHandler(side, true)));
            }
        } else {
            if (cap == GTCapability.CAPABILITY_COVERABLE) {
                return GTCapability.CAPABILITY_COVERABLE.orEmpty(cap, LazyOptional.of(this::getCoverContainer));
            }
            if (cap == GTCapability.CAPABILITY_TOOLABLE) {
                return GTCapability.CAPABILITY_TOOLABLE.orEmpty(cap, LazyOptional.of(() -> this));
            }
        }
        return super.getCapability(cap, side);
    }

    private void ensureHandlersInitialized() {
        if (this.getHandlers().isEmpty()) {
            this.initHandlers();
        }
    }

    public void initHandlers() {
        ItemPipeNet net = this.getItemPipeNet();
        if (net == null) {
            return;
        }
        for (Direction facing : GTUtil.DIRECTIONS) {
            this.handlers.put(facing, new ItemNetHandler(net, this, facing));
        }
    }

    public void checkNetwork() {
        if (!this.hasCurrentNetChanged) {
            return;
        }
        ItemPipeNet current = this.getItemPipeNet();
        for (ItemNetHandler handler : this.handlers.values()) {
            handler.setNetwork(current);
        }
    }

    @Override
    public boolean canAttachTo(Direction side) {
        if (this.level == null) {
            return false;
        }
        if (this.level.getBlockEntity(this.getBlockPos().relative(side)) instanceof ItemPipeBlockEntity) {
            return false;
        }
        return GTTransferUtils.hasAdjacentItemHandler(this.level, this.getBlockPos(), side);
    }

    @Nullable
    public ItemPipeNet getItemPipeNet() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = this.getBlockState().getBlock();
            if (level instanceof ItemPipeBlock) {
                ItemPipeBlock itemPipeBlock = (ItemPipeBlock)level;
                ItemPipeNet currentItemPipeNet = (ItemPipeNet)this.currentItemPipeNet.get();
                if (currentItemPipeNet != null && currentItemPipeNet.isValid() && currentItemPipeNet.containsNode(this.getBlockPos())) {
                    return currentItemPipeNet;
                }
                currentItemPipeNet = (ItemPipeNet)itemPipeBlock.getWorldPipeNet(serverLevel).getNetFromPos(this.getBlockPos());
                if (currentItemPipeNet != null) {
                    this.currentItemPipeNet = new WeakReference<ItemPipeNet>(currentItemPipeNet);
                    this.hasCurrentNetChanged = true;
                }
            }
        }
        return (ItemPipeNet)this.currentItemPipeNet.get();
    }

    public void resetTransferred() {
        this.transferred.clear();
    }

    private void updateTransferredState() {
        long currentTime = this.getLevelTime();
        long dif = currentTime - this.timer;
        if (dif >= 20L || dif < 0L) {
            this.transferredItems = 0;
            this.timer = currentTime;
        }
    }

    public void addTransferredItems(int amount) {
        this.updateTransferredState();
        this.transferredItems += amount;
    }

    public int getTransferredItems() {
        this.updateTransferredState();
        return this.transferredItems;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.handlers.clear();
    }

    public IItemHandlerModifiable getHandler(Direction side, boolean useCoverCapability) {
        this.ensureHandlersInitialized();
        this.checkNetwork();
        if (this.currentItemPipeNet.get() == null) {
            return null;
        }
        ItemNetHandler handler = this.getHandlers().get(side);
        if (!useCoverCapability) {
            return handler;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getItemHandlerCap(handler) : handler;
    }

    @Generated
    public EnumMap<Direction, ItemNetHandler> getHandlers() {
        return this.handlers;
    }

    @Generated
    public Object2IntMap<FacingPos> getTransferred() {
        return this.transferred;
    }
}

