/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.IDataAccessHatch;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.pipelike.optical.LevelOpticalPipeNet;
import com.gregtechceu.gtceu.common.pipelike.optical.OpticalNetHandler;
import com.gregtechceu.gtceu.common.pipelike.optical.OpticalPipeNet;
import com.gregtechceu.gtceu.common.pipelike.optical.OpticalPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.optical.OpticalPipeType;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.gregtechceu.gtceu.utils.TaskHandler;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.EnumMap;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpticalPipeBlockEntity
extends PipeBlockEntity<OpticalPipeType, OpticalPipeProperties> {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(OpticalPipeBlockEntity.class, PipeBlockEntity.MANAGED_FIELD_HOLDER);
    private final EnumMap<Direction, OpticalNetHandler> handlers = new EnumMap(Direction.class);
    private final IDataAccessHatch clientDataHandler = new DefaultDataHandler();
    private final IOpticalComputationProvider clientComputationHandler = new DefaultComputationHandler();
    private WeakReference<OpticalPipeNet> currentPipeNet = new WeakReference<Object>(null);
    private OpticalNetHandler defaultHandler;
    @Persisted
    @DescSynced
    @RequireRerender
    private boolean isActive;

    public OpticalPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    @Override
    public boolean canHaveBlockedFaces() {
        return false;
    }

    private void initHandlers() {
        OpticalPipeNet net = this.getOpticalPipeNet();
        if (net == null) {
            return;
        }
        for (Direction facing : GTUtil.DIRECTIONS) {
            this.handlers.put(facing, new OpticalNetHandler(net, this, facing));
        }
        this.defaultHandler = new OpticalNetHandler(net, this, null);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == GTCapability.CAPABILITY_DATA_ACCESS) {
            if (this.level.isClientSide) {
                return GTCapability.CAPABILITY_DATA_ACCESS.orEmpty(capability, LazyOptional.of(() -> this.clientDataHandler));
            }
            if (facing != null && !this.isConnected(facing)) {
                return LazyOptional.empty();
            }
            if (this.handlers.isEmpty()) {
                this.initHandlers();
            }
            this.checkNetwork();
            return GTCapability.CAPABILITY_DATA_ACCESS.orEmpty(capability, LazyOptional.of(() -> this.handlers.getOrDefault(facing, this.defaultHandler)));
        }
        if (capability == GTCapability.CAPABILITY_COMPUTATION_PROVIDER) {
            if (this.level.isClientSide) {
                return GTCapability.CAPABILITY_COMPUTATION_PROVIDER.orEmpty(capability, LazyOptional.of(() -> this.clientComputationHandler));
            }
            if (facing != null && !this.isConnected(facing)) {
                return LazyOptional.empty();
            }
            if (this.handlers.isEmpty()) {
                this.initHandlers();
            }
            this.checkNetwork();
            return GTCapability.CAPABILITY_COMPUTATION_PROVIDER.orEmpty(capability, LazyOptional.of(() -> this.handlers.getOrDefault(facing, this.defaultHandler)));
        }
        if (capability == GTCapability.CAPABILITY_COVERABLE) {
            return GTCapability.CAPABILITY_COVERABLE.orEmpty(capability, LazyOptional.of(this::getCoverContainer));
        }
        return super.getCapability(capability, facing);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            OpticalPipeNet current = this.getOpticalPipeNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (OpticalNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    public OpticalPipeNet getOpticalPipeNet() {
        if (this.level == null || this.level.isClientSide) {
            return null;
        }
        OpticalPipeNet currentPipeNet = (OpticalPipeNet)this.currentPipeNet.get();
        if (currentPipeNet != null && currentPipeNet.isValid() && currentPipeNet.containsNode(this.getPipePos())) {
            return currentPipeNet;
        }
        LevelOpticalPipeNet worldNet = (LevelOpticalPipeNet)((Object)this.getPipeBlock().getWorldPipeNet((ServerLevel)this.getPipeLevel()));
        currentPipeNet = (OpticalPipeNet)worldNet.getNetFromPos(this.getPipePos());
        if (currentPipeNet != null) {
            this.currentPipeNet = new WeakReference<OpticalPipeNet>(currentPipeNet);
        }
        return currentPipeNet;
    }

    @Override
    public boolean canAttachTo(Direction side) {
        return false;
    }

    @Override
    public void setConnection(Direction side, boolean connected, boolean fromNeighbor) {
        if (!this.getLevel().isClientSide && connected && !fromNeighbor) {
            IPipeNode pipeTile;
            if (this.getNumConnections() >= 2) {
                return;
            }
            BlockEntity tile = this.getLevel().getBlockEntity(this.getPipePos().relative(side));
            if (tile instanceof IPipeNode && (pipeTile = (IPipeNode)tile).getPipeType().getClass() == ((OpticalPipeType)this.getPipeType()).getClass() && pipeTile.getNumConnections() >= 2) {
                return;
            }
        }
        super.setConnection(side, connected, fromNeighbor);
    }

    public void setActive(boolean active, int duration) {
        boolean stateChanged = false;
        if (this.isActive && !active) {
            this.isActive = false;
            stateChanged = true;
        } else if (!this.isActive && active) {
            this.isActive = true;
            stateChanged = true;
            TaskHandler.enqueueServerTask((ServerLevel)this.getLevel(), () -> this.setActive(false, -1), duration);
        }
        if (stateChanged) {
            this.notifyBlockUpdate();
            this.setChanged();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.handlers.clear();
    }

    @Override
    public GTToolType getPipeTuneTool() {
        return GTToolType.WIRE_CUTTER;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Generated
    public boolean isActive() {
        return this.isActive;
    }

    private static class DefaultDataHandler
    implements IDataAccessHatch {
        private DefaultDataHandler() {
        }

        @Override
        public boolean isRecipeAvailable(@NotNull GTRecipe recipe, @NotNull Collection<IDataAccessHatch> seen) {
            return false;
        }

        @Override
        public boolean isCreative() {
            return false;
        }
    }

    private static class DefaultComputationHandler
    implements IOpticalComputationProvider {
        private DefaultComputationHandler() {
        }

        @Override
        public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
            return 0;
        }

        @Override
        public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
            return 0;
        }

        @Override
        public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
            return false;
        }
    }
}

