/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.capability;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IMedicalConditionTracker;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.common.particle.HazardParticleOptions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.BreadthFirstBlockSearch;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalizedHazardSavedData
extends SavedData {
    public static final int MIN_STRENGTH_FOR_SPREAD = 100;
    private final ServerLevel serverLevel;
    private final Map<BlockPos, HazardZone> hazardZones = new HashMap<BlockPos, HazardZone>();

    public static LocalizedHazardSavedData getOrCreate(ServerLevel serverLevel) {
        return (LocalizedHazardSavedData)serverLevel.getDataStorage().computeIfAbsent(tag -> new LocalizedHazardSavedData(serverLevel, (CompoundTag)tag), () -> new LocalizedHazardSavedData(serverLevel), "gtceu_localized_hazard_tracker");
    }

    public LocalizedHazardSavedData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    public LocalizedHazardSavedData(ServerLevel serverLevel, CompoundTag tag) {
        this(serverLevel);
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        ListTag allHazardZones = tag.getList("zones", 10);
        for (int i = 0; i < allHazardZones.size(); ++i) {
            CompoundTag zoneTag = allHazardZones.getCompound(i);
            BlockPos source = BlockPos.of((long)zoneTag.getLong("pos"));
            HazardZone zone = HazardZone.deserializeNBT(zoneTag);
            this.hazardZones.put(source, zone);
        }
    }

    public void tick() {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        Object2IntOpenHashMap zonesToSpread = new Object2IntOpenHashMap();
        RandomSource random = this.serverLevel.random;
        for (Map.Entry<BlockPos, HazardZone> entry : this.hazardZones.entrySet()) {
            HazardZone zone = entry.getValue();
            if (zone.strength() < 20) continue;
            for (BlockPos pos : zone.blocks()) {
                if (!this.serverLevel.isLoaded(pos) || this.serverLevel.getBlockState(pos).isCollisionShapeFullBlock((BlockGetter)this.serverLevel, pos) || GTValues.RNG.nextInt(64000 / zone.strength()) != 0) continue;
                this.serverLevel.sendParticles((ParticleOptions)new HazardParticleOptions(zone.condition().color, (float)zone.strength() / 250.0f), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 1, 0.0, 0.0, 0.0, 0.1);
            }
            Stream<ServerPlayer> playersInZone = this.serverLevel.players().stream().filter(player -> zone.blocks().contains(BlockPos.containing((Position)player.getEyePosition())));
            this.tickPlayerHazards(zone, playersInZone);
            if (!zone.canSpread() || zone.strength() <= 100) continue;
            zonesToSpread.put((Object)entry.getKey(), (zone.strength() - 100) / 500);
        }
        zonesToSpread.forEach(this::expandHazard);
    }

    public void tickPlayerHazards(HazardZone zone, Stream<ServerPlayer> playerStream) {
        playerStream.forEach(player -> {
            if (zone.trigger().protectionType().isProtected((LivingEntity)player)) {
                zone.trigger().protectionType().damageEquipment((Player)player, 1);
                return;
            }
            IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)player);
            if (tracker == null) {
                return;
            }
            tracker.progressCondition(zone.condition(), (float)zone.strength() / 1000.0f);
        });
    }

    @Nullable
    public HazardZone getZoneByContainedPos(BlockPos containedPos) {
        for (HazardZone zone : this.hazardZones.values()) {
            if (!zone.blocks().contains(containedPos)) continue;
            return zone;
        }
        return null;
    }

    @Nullable
    public HazardZone getZoneByContainedPosAndCondition(BlockPos containedPos, MedicalCondition condition) {
        for (HazardZone zone : this.hazardZones.values()) {
            if (zone.condition() != condition || !zone.blocks().contains(containedPos)) continue;
            return zone;
        }
        return null;
    }

    public void removeZoneByPosition(BlockPos containedPos) {
        BlockPos toRemove = null;
        for (Map.Entry<BlockPos, HazardZone> entry : this.hazardZones.entrySet()) {
            if (!entry.getValue().blocks().contains(containedPos)) continue;
            toRemove = entry.getKey();
        }
        this.hazardZones.remove(toRemove);
    }

    public void removeZoneByPosition(BlockPos containedPos, MedicalCondition condition) {
        BlockPos toRemove = null;
        for (Map.Entry<BlockPos, HazardZone> entry : this.hazardZones.entrySet()) {
            if (entry.getValue().condition() != condition || !entry.getValue().blocks().contains(containedPos)) continue;
            toRemove = entry.getKey();
        }
        this.hazardZones.remove(toRemove);
    }

    public boolean expandHazard(BlockPos source, int blocksToAdd) {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return true;
        }
        if (blocksToAdd <= 0) {
            return false;
        }
        if (this.hazardZones.containsKey(source)) {
            HazardZone zone = this.hazardZones.get(source);
            Set<BlockPos> allValidBlocks = BreadthFirstBlockSearch.search(blockPos -> !zone.blocks().contains(blockPos), source, blocksToAdd);
            for (BlockPos found : allValidBlocks) {
                zone.blocks().add(found);
            }
            this.setDirty();
            return true;
        }
        return false;
    }

    public void addSphericalZone(BlockPos source, int sphereRadius, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
        if (this.expandHazard(source, (int)(4.1887902047863905 * Math.pow(sphereRadius, 3.0) / 50.0))) {
            return;
        }
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int x = -sphereRadius; x < sphereRadius; ++x) {
            for (int y = -sphereRadius; y < sphereRadius; ++y) {
                for (int z = -sphereRadius; z < sphereRadius; ++z) {
                    float sizeFractionX = (float)x / (float)sphereRadius;
                    float sizeFractionY = (float)y / (float)sphereRadius;
                    float sizeFractionZ = (float)z / (float)sphereRadius;
                    if (!(sizeFractionX * sizeFractionX + sizeFractionY * sizeFractionY + sizeFractionZ * sizeFractionZ <= 1.0f)) continue;
                    blocks.add(source.offset(x, y, z));
                }
            }
        }
        this.hazardZones.put(source, new HazardZone(blocks, canSpread, trigger, condition));
        this.setDirty();
    }

    public void addCuboidZone(BlockPos source, int sizeX, int sizeY, int sizeZ, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
        if (this.expandHazard(source, sizeX * sizeY * sizeZ / 100)) {
            return;
        }
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        sizeY /= 2;
        sizeZ /= 2;
        for (int x = -(sizeX /= 2); x < sizeX; ++x) {
            for (int y = -sizeY; y < sizeY; ++y) {
                for (int z = -sizeZ; z < sizeZ; ++z) {
                    blocks.add(source.offset(x, y, z));
                }
            }
        }
        this.hazardZones.put(source, new HazardZone(blocks, canSpread, trigger, condition));
        this.setDirty();
    }

    public void addCuboidZone(BlockPos source, int size, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
        if (this.expandHazard(source, size * size * size / 100)) {
            return;
        }
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (int x = -(size /= 2); x < size; ++x) {
            for (int y = -size; y < size; ++y) {
                for (int z = -size; z < size; ++z) {
                    blocks.add(source.offset(x, y, z));
                }
            }
        }
        this.hazardZones.put(source, new HazardZone(blocks, canSpread, trigger, condition));
        this.setDirty();
    }

    public void addCuboidZone(BlockPos source, BlockPos start, BlockPos end, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
        int sizeZ;
        int sizeY;
        int sizeX = start.getX() - end.getX();
        if (this.expandHazard(source, Math.abs(sizeX * (sizeY = start.getY() - end.getY()) * (sizeZ = start.getZ() - end.getZ())) / 100)) {
            return;
        }
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)start, (BlockPos)end)) {
            blocks.add(pos.immutable());
        }
        this.hazardZones.put(source, new HazardZone(blocks, canSpread, trigger, condition));
        this.setDirty();
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag compoundTag) {
        ListTag hazardZonesTag = new ListTag();
        for (Map.Entry<BlockPos, HazardZone> entry : this.hazardZones.entrySet()) {
            CompoundTag zoneTag = new CompoundTag();
            zoneTag.putLong("pos", entry.getKey().asLong());
            entry.getValue().serializeNBT(zoneTag);
            hazardZonesTag.add((Object)zoneTag);
        }
        compoundTag.put("zones", (Tag)hazardZonesTag);
        return compoundTag;
    }

    @Generated
    public Map<BlockPos, HazardZone> getHazardZones() {
        return this.hazardZones;
    }

    public record HazardZone(Set<BlockPos> blocks, boolean canSpread, HazardProperty.HazardTrigger trigger, MedicalCondition condition) {
        public int strength() {
            return this.blocks.size();
        }

        public CompoundTag serializeNBT(CompoundTag zoneTag) {
            ListTag blocksTag = new ListTag();
            this.blocks.stream().map(NbtUtils::writeBlockPos).forEach(arg_0 -> blocksTag.add(arg_0));
            zoneTag.put("blocks", (Tag)blocksTag);
            zoneTag.putBoolean("can_spread", this.canSpread);
            zoneTag.putString("trigger", this.trigger.name());
            zoneTag.putString("condition", this.condition.name);
            return zoneTag;
        }

        public static HazardZone deserializeNBT(CompoundTag zoneTag) {
            Set<BlockPos> blocks = zoneTag.getList("blocks", 10).stream().map(CompoundTag.class::cast).map(NbtUtils::readBlockPos).collect(Collectors.toSet());
            boolean canSpread = zoneTag.getBoolean("can_spread");
            HazardProperty.HazardTrigger trigger = HazardProperty.HazardTrigger.ALL_TRIGGERS.get(zoneTag.getString("trigger"));
            MedicalCondition condition = MedicalCondition.CONDITIONS.get(zoneTag.getString("condition"));
            return new HazardZone(blocks, canSpread, trigger, condition);
        }
    }
}

