/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.capability;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class WorldIDSaveData
extends SavedData {
    private static WorldIDSaveData instance;
    private static final String DATA_NAME = "gtceu_world_id";
    private String worldID;

    public WorldIDSaveData(ServerLevel level) {
        this.worldID = level.getServer().getWorldData().getLevelName() + "_" + String.valueOf(UUID.randomUUID());
        this.setDirty();
    }

    public WorldIDSaveData(CompoundTag tag) {
        this.worldID = tag.getString("id");
    }

    public CompoundTag save(CompoundTag compoundTag) {
        compoundTag.putString("id", this.worldID);
        return compoundTag;
    }

    public static void init(ServerLevel world) {
        instance = (WorldIDSaveData)world.getDataStorage().computeIfAbsent(WorldIDSaveData::new, () -> new WorldIDSaveData(world), DATA_NAME);
    }

    public static String getWorldID() {
        return WorldIDSaveData.instance.worldID;
    }
}

