/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.commands;

import com.gregtechceu.gtceu.common.network.GTNetwork;
import com.gregtechceu.gtceu.common.network.packets.SCPacketShareProspection;
import com.gregtechceu.gtceu.integration.map.ClientCacheManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;

public class GTClientCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"gtceu").then(Commands.literal((String)"share_prospection_data").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            Thread sendThread = new Thread(new ProspectingShareTask(((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID(), player.getUUID()));
            sendThread.start();
            return 1;
        }))));
    }

    private static class ProspectingShareTask
    implements Runnable {
        private final List<ClientCacheManager.ProspectionInfo> prospectionData = ClientCacheManager.getProspectionShareData();
        private final UUID sender;
        private final UUID reciever;

        public ProspectingShareTask(UUID sender, UUID reciever) {
            this.sender = sender;
            this.reciever = reciever;
        }

        @Override
        public void run() {
            boolean first = true;
            for (ClientCacheManager.ProspectionInfo info : this.prospectionData) {
                GTNetwork.sendToServer(new SCPacketShareProspection(this.sender, this.reciever, info.cacheName, info.key, info.isDimCache, info.dim, info.data, first));
                first = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

