/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.commands.arguments;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.registry.GTRegistry;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GTRegistryArgument<K, V>
implements ArgumentType<V> {
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.id.invalid"));
    private static final Collection<String> EXAMPLES = Arrays.asList("gtceu:iron_vein", "gtceu:pitchblende_vein_end", "gtceu:lava_deposit");
    private final GTRegistry<K, V> registry;
    private final Class<K> keyClass;

    public GTRegistryArgument(GTRegistry<K, V> registry, Class<K> keyClass) {
        this.registry = registry;
        this.keyClass = keyClass;
    }

    public static <K, V> GTRegistryArgument<K, V> registry(GTRegistry<K, V> registry, Class<K> keyClass) {
        return new GTRegistryArgument<K, V>(registry, keyClass);
    }

    public V parse(StringReader reader) throws CommandSyntaxException {
        String id = GTRegistryArgument.readId(reader);
        if (ResourceLocation.class.isAssignableFrom(this.keyClass)) {
            ResourceLocation loc = new ResourceLocation(id);
            if (!this.registry.containKey(loc)) {
                throw new SimpleCommandExceptionType((Message)new LiteralMessage("Failed to find object" + id + " in registry")).createWithContext((ImmutableStringReader)reader);
            }
            return this.registry.get(loc);
        }
        if (String.class.isAssignableFrom(this.keyClass)) {
            String loc = id;
            if (!this.registry.containKey(loc)) {
                throw new SimpleCommandExceptionType((Message)Component.literal((String)("Failed to find object " + id + " in registry"))).createWithContext((ImmutableStringReader)reader);
            }
            return this.registry.get(loc);
        }
        throw new SimpleCommandExceptionType((Message)Component.literal((String)"Invalid key class! this should never happen!")).createWithContext((ImmutableStringReader)reader);
    }

    public static String readId(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        while (reader.canRead() && ResourceLocation.isAllowedInResourceLocation((char)reader.peek())) {
            reader.skip();
        }
        String s = reader.getString().substring(cursor, reader.getCursor());
        try {
            return s;
        }
        catch (ResourceLocationException var4) {
            reader.setCursor(cursor);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder builder) {
        String string = builder.getRemaining().toLowerCase(Locale.ROOT);
        GTRegistryArgument.filterResources(this.registry.keys(), string, Function.identity(), id -> builder.suggest(id.toString()));
        return builder.buildFuture();
    }

    static <T, K> void filterResources(Iterable<T> resources, String input, Function<T, K> locationFunction, Consumer<T> resourceConsumer) {
        for (T object : resources) {
            K id = locationFunction.apply(object);
            String string = id.toString();
            if (!GTRegistryArgument.matchesSubStr(input, string)) continue;
            resourceConsumer.accept(object);
        }
    }

    static boolean matchesSubStr(String input, String substring) {
        int i = 0;
        while (!substring.startsWith(input, i)) {
            if ((i = substring.indexOf(95, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @MethodsReturnNonnullByDefault
    public static class Info<K, V>
    implements ArgumentTypeInfo<GTRegistryArgument<K, V>, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.writeResourceLocation(template.registryKey.getRegistryName());
            buffer.writeBoolean(ResourceLocation.class.isAssignableFrom(template.keyClass));
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            ResourceLocation resourceLocation = buffer.readResourceLocation();
            Class<String> keyClass = String.class;
            if (buffer.readBoolean()) {
                keyClass = ResourceLocation.class;
            }
            return new Template(GTRegistry.REGISTERED.get(resourceLocation), keyClass);
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("registry", template.registryKey.getRegistryName().toString());
        }

        public Template unpack(GTRegistryArgument<K, V> argument) {
            return new Template(argument.registry, argument.keyClass);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<GTRegistryArgument<K, V>> {
            final GTRegistry<K, V> registryKey;
            final Class<K> keyClass;

            Template(GTRegistry<K, V> registryKey, Class<K> keyClass) {
                this.registryKey = registryKey;
                this.keyClass = keyClass;
            }

            public GTRegistryArgument<K, V> instantiate(@NotNull CommandBuildContext context) {
                return new GTRegistryArgument(this.registryKey, this.keyClass);
            }

            public ArgumentTypeInfo<GTRegistryArgument<K, V>, ?> type() {
                return Info.this;
            }
        }
    }
}

