/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class InfiniteWaterCover
extends CoverBehavior {
    private TickableSubscription subscription;

    public InfiniteWaterCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        return super.canAttach() && FluidUtil.getFluidHandler((Level)this.coverHolder.getLevel(), (BlockPos)this.coverHolder.getPos(), (Direction)this.attachedSide).isPresent();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscription = this.coverHolder.subscribeServerTick(this.subscription, this::update);
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        if (this.subscription != null) {
            this.subscription.unsubscribe();
        }
    }

    public void update() {
        if (this.coverHolder.getOffsetTimer() % 20L == 0L) {
            FluidUtil.getFluidHandler((Level)this.coverHolder.getLevel(), (BlockPos)this.coverHolder.getPos(), (Direction)this.attachedSide).ifPresent(h -> h.fill(new FluidStack((Fluid)Fluids.WATER, 16000), IFluidHandler.FluidAction.EXECUTE));
        }
    }
}

