/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IIOCover;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandler;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandlers;
import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.NumberInputWidget;
import com.gregtechceu.gtceu.api.machine.ConditionalSubscriptionHandler;
import com.gregtechceu.gtceu.api.transfer.fluid.FluidHandlerDelegate;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.api.transfer.fluid.ModifiableFluidHandlerWrapper;
import com.gregtechceu.gtceu.common.cover.data.BucketMode;
import com.gregtechceu.gtceu.common.cover.data.ManualIOMode;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PumpCover
extends CoverBehavior
implements IIOCover,
IUICover,
IControllable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PumpCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    public static final Int2IntFunction PUMP_SCALING = tier -> 64 * (int)Math.pow(4.0, Math.min(tier - 1, 5));
    public final int tier;
    public final int maxFluidTransferRate;
    @Persisted
    @DescSynced
    protected int transferRate;
    @Persisted
    @DescSynced
    @RequireRerender
    protected IO io = IO.OUT;
    @Persisted
    @DescSynced
    protected BucketMode bucketMode = BucketMode.MILLI_BUCKET;
    @Persisted
    @DescSynced
    protected ManualIOMode manualIOMode = ManualIOMode.DISABLED;
    @Persisted
    @DescSynced
    protected boolean isWorkingEnabled = true;
    protected int mBLeftToTransferLastSecond;
    @Persisted
    @DescSynced
    protected final FilterHandler<FluidStack, FluidFilter> filterHandler;
    protected final ConditionalSubscriptionHandler subscriptionHandler;
    private NumberInputWidget<Integer> transferRateWidget;
    private CoverableFluidHandlerWrapper fluidHandlerWrapper;

    public PumpCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide, int tier, int maxTransferRate) {
        super(definition, coverHolder, attachedSide);
        this.tier = tier;
        this.transferRate = this.maxFluidTransferRate = maxTransferRate;
        this.mBLeftToTransferLastSecond = this.transferRate * 20;
        this.subscriptionHandler = new ConditionalSubscriptionHandler(coverHolder, this::update, this::isSubscriptionActive);
        this.filterHandler = FilterHandlers.fluid(this).onFilterLoaded(f -> this.configureFilter()).onFilterUpdated(f -> this.configureFilter()).onFilterRemoved(f -> this.configureFilter());
    }

    public PumpCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide, int tier) {
        this(definition, coverHolder, attachedSide, tier, PUMP_SCALING.applyAsInt(tier));
    }

    protected boolean isSubscriptionActive() {
        return this.isWorkingEnabled() && this.getAdjacentFluidHandler() != null;
    }

    @Nullable
    protected IFluidHandlerModifiable getOwnFluidHandler() {
        return this.coverHolder.getFluidHandlerCap(this.attachedSide, false);
    }

    @Nullable
    protected IFluidHandler getAdjacentFluidHandler() {
        return GTTransferUtils.getAdjacentFluidHandler(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide).resolve().orElse(null);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public boolean canAttach() {
        return super.canAttach() && this.getOwnFluidHandler() != null;
    }

    public void setIo(IO io) {
        if (io == IO.IN || io == IO.OUT) {
            this.io = io;
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.subscriptionHandler.initialize(this.coverHolder.getLevel());
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        this.subscriptionHandler.unsubscribe();
    }

    @Override
    public List<ItemStack> getAdditionalDrops() {
        List<ItemStack> list = super.getAdditionalDrops();
        if (!this.filterHandler.getFilterItem().isEmpty()) {
            list.add(this.filterHandler.getFilterItem());
        }
        return list;
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        this.subscriptionHandler.updateSubscription();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (this.isWorkingEnabled != isWorkingAllowed) {
            this.isWorkingEnabled = isWorkingAllowed;
            this.subscriptionHandler.updateSubscription();
        }
    }

    public void setTransferRate(int milliBucketsPerTick) {
        this.transferRate = Math.min(Math.max(milliBucketsPerTick, 0), this.maxFluidTransferRate);
    }

    public void setBucketMode(BucketMode bucketMode) {
        int oldMultiplier = this.bucketMode.multiplier;
        int newMultiplier = bucketMode.multiplier;
        this.bucketMode = bucketMode;
        if (this.transferRateWidget == null) {
            return;
        }
        if (oldMultiplier > newMultiplier) {
            this.transferRateWidget.setValue(this.getCurrentBucketModeTransferRate());
        }
        this.transferRateWidget.setMax(this.maxFluidTransferRate / bucketMode.multiplier);
        if (newMultiplier > oldMultiplier) {
            this.transferRateWidget.setValue(this.getCurrentBucketModeTransferRate());
        }
    }

    protected void setManualIOMode(ManualIOMode manualIOMode) {
        this.manualIOMode = manualIOMode;
        this.coverHolder.markDirty();
    }

    protected void update() {
        long timer = this.coverHolder.getOffsetTimer();
        if (timer % 5L != 0L) {
            return;
        }
        if (this.mBLeftToTransferLastSecond > 0) {
            int platformTransferredFluid = this.doTransferFluids(this.mBLeftToTransferLastSecond);
            this.mBLeftToTransferLastSecond -= platformTransferredFluid;
        }
        if (timer % 20L == 0L) {
            this.mBLeftToTransferLastSecond = this.transferRate * 20;
        }
        this.subscriptionHandler.updateSubscription();
    }

    private int doTransferFluids(int platformTransferLimit) {
        IFluidHandlerModifiable iFluidHandlerModifiable;
        IFluidHandler adjacent = this.getAdjacentFluidHandler();
        if (adjacent instanceof IFluidHandlerModifiable) {
            IFluidHandlerModifiable modifiable = (IFluidHandlerModifiable)adjacent;
            iFluidHandlerModifiable = modifiable;
        } else {
            iFluidHandlerModifiable = new ModifiableFluidHandlerWrapper(adjacent);
        }
        IFluidHandlerModifiable adjacentModifiable = iFluidHandlerModifiable;
        IFluidHandlerModifiable ownFluidHandler = this.getOwnFluidHandler();
        if (adjacent != null && ownFluidHandler != null) {
            return switch (this.io) {
                case IO.IN -> this.doTransferFluidsInternal(adjacentModifiable, ownFluidHandler, platformTransferLimit);
                case IO.OUT -> this.doTransferFluidsInternal(ownFluidHandler, adjacentModifiable, platformTransferLimit);
                default -> 0;
            };
        }
        return 0;
    }

    protected int doTransferFluidsInternal(IFluidHandlerModifiable source, IFluidHandlerModifiable destination, int platformTransferLimit) {
        return this.transferAny(source, destination, platformTransferLimit);
    }

    protected int transferAny(IFluidHandlerModifiable source, IFluidHandlerModifiable destination, int platformTransferLimit) {
        return GTTransferUtils.transferFluidsFiltered(source, destination, this.filterHandler.getFilter(), platformTransferLimit);
    }

    protected Object2LongMap<FluidStack> enumerateDistinctFluids(IFluidHandlerModifiable fluidHandler, TransferDirection direction) {
        Object2LongOpenHashMap summedFluids = new Object2LongOpenHashMap();
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack fluidStack;
            if (!PumpCover.canTransfer(fluidHandler, direction, tank) || (fluidStack = fluidHandler.getFluidInTank(tank)).isEmpty()) continue;
            summedFluids.addTo((Object)fluidStack, (long)fluidStack.getAmount());
        }
        return summedFluids;
    }

    private static boolean canTransfer(IFluidHandlerModifiable fluidHandler, TransferDirection direction, int tank) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case TransferDirection.INSERT -> fluidHandler.supportsFill(tank);
            case TransferDirection.EXTRACT -> fluidHandler.supportsDrain(tank);
        };
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 137);
        group.addWidget((Widget)new LabelWidget(10, 5, Component.translatable((String)this.getUITitle(), (Object[])new Object[]{GTValues.VN[this.tier]}).getString()));
        this.transferRateWidget = new IntInputWidget(10, 20, 134, 20, this::getCurrentBucketModeTransferRate, this::setCurrentBucketModeTransferRate).setMin(0);
        this.setBucketMode(this.bucketMode);
        group.addWidget(this.transferRateWidget);
        group.addWidget(new EnumSelectorWidget<BucketMode>(146, 20, 20, 20, Arrays.stream(BucketMode.values()).filter(m -> m.multiplier <= this.maxFluidTransferRate).toList(), this.bucketMode, this::setBucketMode).setTooltipSupplier(this::getBucketModeTooltip));
        group.addWidget(new EnumSelectorWidget<IO>(10, 45, 20, 20, List.of(IO.IN, IO.OUT), this.io, this::setIo));
        group.addWidget(new EnumSelectorWidget(146, 107, 20, 20, (Enum[])ManualIOMode.VALUES, (Enum)this.manualIOMode, this::setManualIOMode).setHoverTooltips(new String[]{"cover.universal.manual_import_export.mode.description"}));
        group.addWidget(this.filterHandler.createFilterSlotUI(125, 108));
        group.addWidget(this.filterHandler.createFilterConfigUI(10, 72, 156, 60));
        this.buildAdditionalUI(group);
        return group;
    }

    private List<Component> getBucketModeTooltip(BucketMode mode, String langKey) {
        return List.of(Component.translatable((String)langKey).append((Component)Component.translatable((String)"gtceu.gui.content.units.per_tick")));
    }

    private int getCurrentBucketModeTransferRate() {
        return this.transferRate / this.bucketMode.multiplier;
    }

    private void setCurrentBucketModeTransferRate(int transferRate) {
        this.setTransferRate(transferRate * this.bucketMode.multiplier);
    }

    @NotNull
    protected String getUITitle() {
        return "cover.pump.title";
    }

    protected void buildAdditionalUI(WidgetGroup group) {
    }

    protected void configureFilter() {
    }

    @Override
    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable IFluidHandlerModifiable defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        if (this.fluidHandlerWrapper == null || this.fluidHandlerWrapper.delegate != defaultValue) {
            this.fluidHandlerWrapper = new CoverableFluidHandlerWrapper(defaultValue);
        }
        return this.fluidHandlerWrapper;
    }

    @Override
    @Generated
    public int getTransferRate() {
        return this.transferRate;
    }

    @Override
    @Generated
    public IO getIo() {
        return this.io;
    }

    @Generated
    public BucketMode getBucketMode() {
        return this.bucketMode;
    }

    @Override
    @Generated
    public ManualIOMode getManualIOMode() {
        return this.manualIOMode;
    }

    @Override
    @Generated
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    protected static enum TransferDirection {
        INSERT,
        EXTRACT;

    }

    private class CoverableFluidHandlerWrapper
    extends FluidHandlerDelegate {
        public CoverableFluidHandlerWrapper(IFluidHandlerModifiable delegate) {
            super(delegate);
        }

        @Override
        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (PumpCover.this.io == IO.OUT && PumpCover.this.manualIOMode == ManualIOMode.DISABLED) {
                return 0;
            }
            if (!PumpCover.this.filterHandler.test(resource) && PumpCover.this.manualIOMode == ManualIOMode.FILTERED) {
                return 0;
            }
            return super.fill(resource, action);
        }

        @Override
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (PumpCover.this.io == IO.IN && PumpCover.this.manualIOMode == ManualIOMode.DISABLED) {
                return FluidStack.EMPTY;
            }
            if (PumpCover.this.manualIOMode == ManualIOMode.FILTERED && !PumpCover.this.filterHandler.test(resource)) {
                return FluidStack.EMPTY;
            }
            return super.drain(resource, action);
        }
    }
}

