/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.placeholder.IPlaceholderInfoProviderCover;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class WirelessTransmitterCover
extends CoverBehavior
implements IDataStickInteractable,
IPlaceholderInfoProviderCover {
    private static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(WirelessTransmitterCover.class, CoverBehavior.MANAGED_FIELD_HOLDER);
    private final List<MutableComponent> createDisplayTargetBuffer = new ArrayList<MutableComponent>();
    private final List<MutableComponent> computerCraftTextBuffer = new ArrayList<MutableComponent>();

    public WirelessTransmitterCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
        for (int i = 0; i < 100; ++i) {
            this.createDisplayTargetBuffer.add(MutableComponent.create((ComponentContents)ComponentContents.EMPTY));
            this.computerCraftTextBuffer.add(MutableComponent.create((ComponentContents)ComponentContents.EMPTY));
        }
    }

    @Override
    public InteractionResult onDataStickUse(Player player, ItemStack dataStick) {
        dataStick.getOrCreateTag().putInt("targetX", this.coverHolder.getPos().getX());
        dataStick.getOrCreateTag().putInt("targetY", this.coverHolder.getPos().getY());
        dataStick.getOrCreateTag().putInt("targetZ", this.coverHolder.getPos().getZ());
        dataStick.getOrCreateTag().putString("face", this.attachedSide.getName());
        dataStick.getOrCreateTag().putString("dim", this.coverHolder.getLevel().dimension().location().toString());
        return InteractionResult.SUCCESS;
    }

    @Override
    public long getTicksSincePlaced() {
        return this.coverHolder.getOffsetTimer();
    }

    @Override
    public void setDisplayTargetBufferLine(int line, MutableComponent component) {
        this.createDisplayTargetBuffer.set(line, component);
    }

    @Override
    public void setComputerCraftTextBufferLine(int line, MutableComponent component) {
        this.computerCraftTextBuffer.set(line, component);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Generated
    public List<MutableComponent> getCreateDisplayTargetBuffer() {
        return this.createDisplayTargetBuffer;
    }

    @Generated
    public List<MutableComponent> getComputerCraftTextBuffer() {
        return this.computerCraftTextBuffer;
    }
}

