/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.voiding;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.cover.filter.SimpleItemFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.common.cover.ConveyorCover;
import com.gregtechceu.gtceu.common.cover.data.VoidingMode;
import com.gregtechceu.gtceu.common.cover.voiding.ItemVoidingCover;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AdvancedItemVoidingCover
extends ItemVoidingCover {
    @Persisted
    @DescSynced
    private VoidingMode voidingMode = VoidingMode.VOID_ANY;
    @Persisted
    protected int globalVoidingLimit = 1;
    private IntInputWidget stackSizeInput;
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(AdvancedItemVoidingCover.class, ItemVoidingCover.MANAGED_FIELD_HOLDER);

    public AdvancedItemVoidingCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    protected void doVoidItems() {
        IItemHandlerModifiable handler = this.getOwnItemHandler();
        if (handler == null) {
            return;
        }
        switch (this.voidingMode) {
            case VOID_ANY: {
                this.voidAny((IItemHandler)handler);
                break;
            }
            case VOID_OVERFLOW: {
                this.voidOverflow((IItemHandler)handler);
            }
        }
    }

    private void voidOverflow(IItemHandler handler) {
        Map<ItemStack, ConveyorCover.TypeItemInfo> sourceItemAmounts = this.countInventoryItemsByType(handler);
        block0: for (ConveyorCover.TypeItemInfo itemInfo : sourceItemAmounts.values()) {
            int itemToVoidAmount = itemInfo.totalCount - this.getFilteredItemAmount(itemInfo.itemStack);
            if (itemToVoidAmount <= 0) continue;
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack extracted;
                ItemStack is = handler.getStackInSlot(slot);
                if (!is.isEmpty() && GTUtil.isSameItemSameTags(is, itemInfo.itemStack) && !(extracted = handler.extractItem(slot, itemToVoidAmount, false)).isEmpty()) {
                    itemToVoidAmount -= extracted.getCount();
                }
                if (itemToVoidAmount == 0) continue block0;
            }
        }
    }

    private int getFilteredItemAmount(ItemStack itemStack) {
        if (!this.filterHandler.isFilterPresent()) {
            return this.globalVoidingLimit;
        }
        ItemFilter filter = (ItemFilter)this.filterHandler.getFilter();
        return filter.isBlackList() ? this.globalVoidingLimit : filter.testItemCount(itemStack);
    }

    public void setVoidingMode(VoidingMode voidingMode) {
        this.voidingMode = voidingMode;
        this.configureStackSizeInput();
        if (!this.isRemote()) {
            this.configureFilter();
        }
    }

    @Override
    @NotNull
    protected String getUITitle() {
        return "cover.item.voiding.advanced.title";
    }

    @Override
    protected void buildAdditionalUI(WidgetGroup group) {
        group.addWidget((Widget)new EnumSelectorWidget(146, 20, 20, 20, (Enum[])VoidingMode.values(), (Enum)this.voidingMode, this::setVoidingMode));
        this.stackSizeInput = new IntInputWidget(64, 20, 80, 20, () -> this.globalVoidingLimit, val -> {
            this.globalVoidingLimit = val;
        });
        this.configureStackSizeInput();
        group.addWidget((Widget)this.stackSizeInput);
    }

    @Override
    protected void configureFilter() {
        Object f = this.filterHandler.getFilter();
        if (f instanceof SimpleItemFilter) {
            SimpleItemFilter filter = (SimpleItemFilter)f;
            filter.setMaxStackSize(this.voidingMode.maxStackSize);
        }
        this.configureStackSizeInput();
    }

    private void configureStackSizeInput() {
        if (this.stackSizeInput == null) {
            return;
        }
        this.stackSizeInput.setVisible(this.shouldShowStackSize());
        this.stackSizeInput.setMin(1);
        this.stackSizeInput.setMax(this.voidingMode.maxStackSize);
    }

    private boolean shouldShowStackSize() {
        if (this.voidingMode == VoidingMode.VOID_ANY) {
            return false;
        }
        if (!this.filterHandler.isFilterPresent()) {
            return true;
        }
        return ((ItemFilter)this.filterHandler.getFilter()).isBlackList();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Generated
    public VoidingMode getVoidingMode() {
        return this.voidingMode;
    }

    @Generated
    public int getGlobalVoidingLimit() {
        return this.globalVoidingLimit;
    }
}

