/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.data.GTPlacements;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class GTBiomeModifiers {
    public static final ResourceKey<BiomeModifier> RUBBER = ResourceKey.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)GTCEu.id("rubber_tree"));
    public static final ResourceKey<BiomeModifier> STONE_BLOB = ResourceKey.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)GTCEu.id("stone_blob"));
    public static final ResourceKey<BiomeModifier> RAW_OIL_SPROUT = ResourceKey.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)GTCEu.id("raw_oil_sprout"));

    public static void bootstrap(BootstapContext<BiomeModifier> ctx) {
        HolderGetter biomeLookup = ctx.lookup(Registries.BIOME);
        HolderGetter placedFeatureRegistry = ctx.lookup(Registries.PLACED_FEATURE);
        HolderSet.Named biomes = biomeLookup.getOrThrow(CustomTags.HAS_RUBBER_TREE);
        Holder.Reference rubberTree = placedFeatureRegistry.getOrThrow(GTPlacements.RUBBER_CHECKED);
        ctx.register(RUBBER, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes, (HolderSet)HolderSet.direct((Holder[])new Holder[]{rubberTree}), GenerationStep.Decoration.VEGETAL_DECORATION));
        HolderSet.Named overworld = biomeLookup.getOrThrow(BiomeTags.IS_OVERWORLD);
        Holder.Reference redGraniteBlob = placedFeatureRegistry.getOrThrow(GTPlacements.RED_GRANITE_BLOB);
        Holder.Reference marbleBlob = placedFeatureRegistry.getOrThrow(GTPlacements.MARBLE_BLOB);
        ctx.register(STONE_BLOB, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworld, (HolderSet)HolderSet.direct((Holder[])new Holder[]{redGraniteBlob, marbleBlob}), GenerationStep.Decoration.UNDERGROUND_ORES));
        Holder.Reference rawOilSprout = placedFeatureRegistry.getOrThrow(GTPlacements.RAW_OIL_SPROUT);
        ctx.register(RAW_OIL_SPROUT, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworld, (HolderSet)HolderSet.direct((Holder[])new Holder[]{rawOilSprout}), GenerationStep.Decoration.FLUID_SPRINGS));
    }
}

