/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.entity;

import com.gregtechceu.gtceu.common.data.GTEntityTypes;
import com.gregtechceu.gtceu.common.data.GTItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DynamiteEntity
extends ThrowableItemProjectile {
    private int ticksUntilExplosion;

    public DynamiteEntity(EntityType<DynamiteEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public DynamiteEntity(double x, double y, double z, Level worldIn) {
        super((EntityType)GTEntityTypes.DYNAMITE.get(), x, y, z, worldIn);
    }

    public DynamiteEntity(LivingEntity throwerIn, Level worldIn) {
        super((EntityType)GTEntityTypes.DYNAMITE.get(), throwerIn, worldIn);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.ticksUntilExplosion = 80 + this.level().random.nextInt(60);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)GTItems.DYNAMITE.get();
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        super.onHitBlock(result);
        Vec3 vec3 = result.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(vec3);
        Vec3 vec31 = vec3.normalize().scale((double)0.05f);
        this.setPosRaw(this.getX() - vec31.x, this.getY() - vec31.y, this.getZ() - vec31.z);
    }

    public void tick() {
        --this.ticksUntilExplosion;
        if (this.level().random.nextInt(3) == 2) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY(), this.getZ(), -this.getDeltaMovement().x * (double)0.05f, this.onGround() ? (double)0.05f : -this.getDeltaMovement().y * (double)0.05f, -this.getDeltaMovement().z * (double)0.05f);
        }
        if (this.ticksUntilExplosion < 0 && !this.level().isClientSide) {
            Entity thrower = this.getOwner();
            this.level().explode((Entity)(thrower == null ? this : thrower), this.getX(), this.getY(), this.getZ(), 1.5f, Level.ExplosionInteraction.TNT);
            this.discard();
            return;
        }
        super.tick();
    }
}

