/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.entity;

import com.gregtechceu.gtceu.common.data.GTEntityTypes;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.entity.GTBoat;
import com.gregtechceu.gtceu.common.item.GTBoatItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class GTChestBoat
extends ChestBoat {
    public GTChestBoat(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
        this.blocksBuilding = true;
    }

    public GTChestBoat(Level level, double x, double y, double z) {
        super((EntityType)GTEntityTypes.CHEST_BOAT.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("Type", this.getBoatType().getName());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Type")) {
            this.entityData.set(DATA_ID_TYPE, (Object)GTBoat.BoatType.byName(compound.getString("Type")).ordinal());
        }
    }

    public Item getDropItem() {
        return switch (GTBoat.BoatType.byId((Integer)this.entityData.get(DATA_ID_TYPE))) {
            default -> throw new IncompatibleClassChangeError();
            case GTBoat.BoatType.RUBBER -> (GTBoatItem)((Object)GTItems.RUBBER_CHEST_BOAT.get());
            case GTBoat.BoatType.TREATED_WOOD -> (GTBoatItem)((Object)GTItems.TREATED_WOOD_CHEST_BOAT.get());
        };
    }

    public void setBoatType(GTBoat.BoatType type) {
        this.entityData.set(DATA_ID_TYPE, (Object)type.ordinal());
    }

    public GTBoat.BoatType getBoatType() {
        return GTBoat.BoatType.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    public void setVariant(Boat.Type variant) {
    }

    public Boat.Type getVariant() {
        return Boat.Type.OAK;
    }
}

