/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import appeng.api.util.AEColor;
import appeng.blockentity.networking.CableBusBlockEntity;
import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.BreadthFirstBlockSearch;
import com.gregtechceu.gtceu.utils.GradientUtil;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.Nullable;

public class ColorSprayBehaviour
implements IDurabilityBar,
IInteractionItem,
IAddInformation {
    private static final ImmutableMap<DyeColor, Block> GLASS_MAP;
    private static final ImmutableMap<DyeColor, Block> GLASS_PANE_MAP;
    private static final ImmutableMap<DyeColor, Block> TERRACOTTA_MAP;
    private static final ImmutableMap<DyeColor, Block> WOOL_MAP;
    private static final ImmutableMap<DyeColor, Block> CARPET_MAP;
    private static final ImmutableMap<DyeColor, Block> CONCRETE_MAP;
    private static final ImmutableMap<DyeColor, Block> CONCRETE_POWDER_MAP;
    private static final ImmutableMap<DyeColor, Block> SHULKER_BOX_MAP;
    private static final ImmutableMap<DyeColor, Block> CANDLE_MAP;
    private final Supplier<ItemStack> empty;
    private final DyeColor color;
    public final int totalUses;
    private final IntIntPair durabilityBarColors;
    private static final TriPredicate<IPaintable, IPaintable, Direction> paintablePredicate;
    private static final TriPredicate<IPipeNode, IPipeNode, Direction> gtPipePredicate;

    private static Block getBlock(DyeColor color, String postfix) {
        ResourceLocation id = new ResourceLocation("minecraft", color.getSerializedName() + "_" + postfix);
        return (Block)BuiltInRegistries.BLOCK.get(id);
    }

    public ColorSprayBehaviour(Supplier<ItemStack> empty, int totalUses, int color) {
        this.empty = empty;
        DyeColor[] colors = DyeColor.values();
        this.color = color >= colors.length || color < 0 ? null : colors[color];
        int colorValue = this.color == null ? 0x969696 : this.color.getTextColor();
        this.totalUses = totalUses;
        this.durabilityBarColors = GradientUtil.getGradient(colorValue, 10);
    }

    @Override
    public float getDurabilityForDisplay(ItemStack stack) {
        return (float)this.getUsesLeft(stack) / (float)this.totalUses;
    }

    @Override
    public int getMaxDurability(ItemStack stack) {
        return this.totalUses;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, this.getDurabilityForDisplay(stack));
        return ColorSprayBehaviour.mixColors(f, this.durabilityBarColors.leftInt(), this.durabilityBarColors.rightInt());
    }

    @Override
    @Nullable
    public IntIntPair getDurabilityColorsForDisplay(ItemStack itemStack) {
        return this.durabilityBarColors;
    }

    private static int mixColors(float ratio, int ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        ratio *= 1.0f / (float)colors.length;
        for (int color : colors) {
            r = (int)((float)r + (float)FastColor.ARGB32.red((int)color) * ratio);
            g = (int)((float)g + (float)FastColor.ARGB32.green((int)color) * ratio);
            b = (int)((float)b + (float)FastColor.ARGB32.blue((int)color) * ratio);
        }
        return FastColor.ARGB32.color((int)255, (int)r, (int)g, (int)b);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int remainingUses = this.getUsesLeft(stack);
        if (this.color != null) {
            tooltipComponents.add((Component)Component.translatable((String)("behaviour.paintspray." + this.color.getSerializedName() + ".tooltip")));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"behaviour.paintspray.solvent.tooltip"));
        }
        tooltipComponents.add((Component)Component.translatable((String)"behaviour.paintspray.uses", (Object[])new Object[]{remainingUses}));
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (player == null) {
            return InteractionResult.PASS;
        }
        int maxBlocksToRecolor = player.isShiftKeyDown() ? ConfigHolder.INSTANCE.tools.sprayCanChainLength : 1;
        BlockEntity first = level.getBlockEntity(pos);
        if (first == null || !this.handleSpecialBlockEntities(first, maxBlocksToRecolor, context)) {
            this.handleBlocks(pos, maxBlocksToRecolor, context);
        }
        GTSoundEntries.SPRAY_CAN_TOOL.play(level, null, player.position(), 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    private static boolean paintPaintable(IPaintable paintable, DyeColor color) {
        if (color == null) {
            if (!paintable.isPainted()) {
                return false;
            }
            paintable.setPaintingColor(-1);
        } else if (paintable.getPaintingColor() != color.getMapColor().col) {
            paintable.setPaintingColor(color.getMapColor().col);
        } else {
            return false;
        }
        return true;
    }

    private boolean handleSpecialBlockEntities(BlockEntity first, int limit, UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return false;
        }
        if (GTCEu.Mods.isAE2Loaded() && AE2CallWrapper.isAE2Cable(first)) {
            Set<CableBusBlockEntity> collected = AE2CallWrapper.collect(first, limit);
            AEColor ae2Color = this.color == null ? AEColor.TRANSPARENT : AEColor.values()[this.color.ordinal()];
            for (CableBusBlockEntity c : collected) {
                if (c.getColor() == ae2Color) continue;
                c.recolourBlock(context.getClickedFace(), ae2Color, player);
                if (this.useItemDurability(player, context.getHand(), context.getItemInHand(), ItemStack.EMPTY)) continue;
                break;
            }
        } else if (first instanceof IPipeNode) {
            IPipeNode pipe = (IPipeNode)first;
            Set<IPipeNode> collected = BreadthFirstBlockSearch.conditionalSearch(IPipeNode.class, pipe, first.getLevel(), IPipeNode::getPipePos, gtPipePredicate, limit, limit * 6);
            this.paintPaintables(collected, context);
        } else if (first instanceof IPaintable) {
            IPaintable paintable = (IPaintable)first;
            Set<IPaintable> collected = BreadthFirstBlockSearch.conditionalSearch(IPaintable.class, paintable, first.getLevel(), p -> ((BlockEntity)p).getBlockPos(), paintablePredicate, limit, limit * 6);
            this.paintPaintables(collected, context);
        } else if (first instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulkerBox = (ShulkerBoxBlockEntity)first;
            CompoundTag tag = shulkerBox.saveWithoutMetadata();
            Level level = first.getLevel();
            BlockPos pos = first.getBlockPos();
            ColorSprayBehaviour.recolorBlockNoState(SHULKER_BOX_MAP, this.color, level, pos, Blocks.SHULKER_BOX);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity newShulker = (ShulkerBoxBlockEntity)blockEntity;
                newShulker.load(tag);
            }
        } else {
            return false;
        }
        return true;
    }

    private void handleBlocks(BlockPos start, int limit, UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack stack = context.getItemInHand();
        Set<BlockPos> collected = BreadthFirstBlockSearch.conditionalBlockPosSearch(start, (parent, child) -> parent == null || level.getBlockState(child).is(level.getBlockState(parent).getBlock()), limit, limit * 6);
        for (BlockPos pos : collected) {
            if (!this.tryPaintBlock(level, pos) || !this.useItemDurability(player, context.getHand(), stack, this.empty.get())) break;
        }
    }

    private <T extends IPaintable> void paintPaintables(Set<T> paintables, UseOnContext context) {
        IPaintable c;
        Iterator<T> iterator = paintables.iterator();
        while (iterator.hasNext() && (!ColorSprayBehaviour.paintPaintable(c = (IPaintable)iterator.next(), this.color) || this.useItemDurability(context.getPlayer(), context.getHand(), context.getItemInHand(), ItemStack.EMPTY))) {
        }
    }

    private boolean tryPaintBlock(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        if (this.color == null) {
            return ColorSprayBehaviour.tryStripBlockColor(level, pos, block);
        }
        return ColorSprayBehaviour.recolorBlockState(level, pos, this.color) || this.tryPaintSpecialBlock(level, pos, block);
    }

    private static boolean recolorBlockState(Level level, BlockPos pos, DyeColor color) {
        BlockState state = level.getBlockState(pos);
        for (Property property : state.getProperties()) {
            if (property.getValueClass() != DyeColor.class) continue;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(property, (Comparable)color));
            return true;
        }
        return false;
    }

    private boolean tryPaintSpecialBlock(Level world, BlockPos pos, Block block) {
        if (block.defaultBlockState().is(Tags.Blocks.GLASS) && ColorSprayBehaviour.recolorBlockNoState(GLASS_MAP, this.color, world, pos, Blocks.GLASS)) {
            return true;
        }
        if (block.defaultBlockState().is(Tags.Blocks.GLASS_PANES) && ColorSprayBehaviour.recolorBlockNoState(GLASS_PANE_MAP, this.color, world, pos, Blocks.GLASS_PANE)) {
            return true;
        }
        if (block.defaultBlockState().is(BlockTags.TERRACOTTA) && ColorSprayBehaviour.recolorBlockNoState(TERRACOTTA_MAP, this.color, world, pos, Blocks.TERRACOTTA)) {
            return true;
        }
        if (block.defaultBlockState().is(BlockTags.WOOL) && ColorSprayBehaviour.recolorBlockNoState(WOOL_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.defaultBlockState().is(BlockTags.WOOL_CARPETS) && ColorSprayBehaviour.recolorBlockNoState(CARPET_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.defaultBlockState().is(CustomTags.CONCRETE_BLOCK) && ColorSprayBehaviour.recolorBlockNoState(CONCRETE_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.defaultBlockState().is(CustomTags.CONCRETE_POWDER_BLOCK) && ColorSprayBehaviour.recolorBlockNoState(CONCRETE_POWDER_MAP, this.color, world, pos)) {
            return true;
        }
        return block.defaultBlockState().is(BlockTags.CANDLES) && ColorSprayBehaviour.recolorBlockNoState(CANDLE_MAP, this.color, world, pos);
    }

    private static boolean recolorBlockNoState(Map<DyeColor, Block> map, DyeColor color, Level world, BlockPos pos) {
        return ColorSprayBehaviour.recolorBlockNoState(map, color, world, pos, null);
    }

    private static boolean recolorBlockNoState(Map<DyeColor, Block> map, @Nullable DyeColor color, Level level, BlockPos pos, Block defaultBlock) {
        Block newBlock = map.getOrDefault(color, defaultBlock);
        if (newBlock == Blocks.AIR) {
            newBlock = defaultBlock;
        }
        BlockState old = level.getBlockState(pos);
        if (newBlock != null && newBlock != old.getBlock()) {
            BlockState state = newBlock.defaultBlockState();
            for (Property property : old.getProperties()) {
                if (!state.hasProperty(property)) continue;
                state.setValue(property, old.getValue(property));
            }
            level.setBlockAndUpdate(pos, state);
            return true;
        }
        return false;
    }

    private static boolean tryStripBlockColor(Level world, BlockPos pos, Block block) {
        if (block instanceof StainedGlassBlock) {
            world.setBlockAndUpdate(pos, Blocks.GLASS.defaultBlockState());
            return true;
        }
        if (block instanceof StainedGlassPaneBlock) {
            world.setBlockAndUpdate(pos, Blocks.GLASS_PANE.defaultBlockState());
            return true;
        }
        if (block.defaultBlockState().is(BlockTags.TERRACOTTA) && block != Blocks.TERRACOTTA) {
            world.setBlockAndUpdate(pos, Blocks.TERRACOTTA.defaultBlockState());
            return true;
        }
        if (block.defaultBlockState().is(BlockTags.WOOL) && block != Blocks.WHITE_WOOL) {
            world.setBlockAndUpdate(pos, Blocks.WHITE_WOOL.defaultBlockState());
            return true;
        }
        if (block.defaultBlockState().is(BlockTags.WOOL_CARPETS) && block != Blocks.WHITE_CARPET) {
            world.setBlockAndUpdate(pos, Blocks.WHITE_CARPET.defaultBlockState());
            return true;
        }
        if (block.defaultBlockState().is(CustomTags.CONCRETE_BLOCK) && block != Blocks.WHITE_CONCRETE) {
            world.setBlockAndUpdate(pos, Blocks.WHITE_CONCRETE.defaultBlockState());
            return true;
        }
        if (block.defaultBlockState().is(CustomTags.CONCRETE_POWDER_BLOCK) && block != Blocks.WHITE_CONCRETE_POWDER) {
            world.setBlockAndUpdate(pos, Blocks.WHITE_CONCRETE_POWDER.defaultBlockState());
            return true;
        }
        if (block.defaultBlockState().is(BlockTags.CANDLES) && block != Blocks.WHITE_CANDLE) {
            ColorSprayBehaviour.recolorBlockNoState(CANDLE_MAP, DyeColor.WHITE, world, pos);
            return true;
        }
        BlockState state = world.getBlockState(pos);
        for (Property prop : state.getProperties()) {
            if (prop.getValueClass() != DyeColor.class) continue;
            BlockState defaultState = block.defaultBlockState();
            DyeColor defaultColor = DyeColor.WHITE;
            try {
                defaultColor = (DyeColor)defaultState.getValue(prop);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ColorSprayBehaviour.recolorBlockState(world, pos, defaultColor);
            return true;
        }
        return false;
    }

    public boolean useItemDurability(Player player, InteractionHand hand, ItemStack stack, ItemStack replacementStack) {
        int usesLeft = this.getUsesLeft(stack);
        if (!player.isCreative()) {
            if (--usesLeft <= 0) {
                if (replacementStack.isEmpty()) {
                    stack.shrink(1);
                } else {
                    player.setItemInHand(hand, replacementStack);
                }
                return false;
            }
            ColorSprayBehaviour.setUsesLeft(stack, usesLeft);
        }
        return true;
    }

    public final int getUsesLeft(ItemStack stack) {
        CompoundTag tagCompound = stack.getTag();
        if (tagCompound == null || !tagCompound.contains("UsesLeft", 3)) {
            return this.totalUses;
        }
        return tagCompound.getInt("UsesLeft");
    }

    public static void setUsesLeft(ItemStack itemStack, int usesLeft) {
        CompoundTag tagCompound = itemStack.getOrCreateTag();
        tagCompound.putInt("UsesLeft", usesLeft);
    }

    static {
        ImmutableMap.Builder glassBuilder = ImmutableMap.builder();
        ImmutableMap.Builder glassPaneBuilder = ImmutableMap.builder();
        ImmutableMap.Builder terracottaBuilder = ImmutableMap.builder();
        ImmutableMap.Builder woolBuilder = ImmutableMap.builder();
        ImmutableMap.Builder carpetBuilder = ImmutableMap.builder();
        ImmutableMap.Builder concreteBuilder = ImmutableMap.builder();
        ImmutableMap.Builder concretePowderBuilder = ImmutableMap.builder();
        ImmutableMap.Builder shulkerBoxBuilder = ImmutableMap.builder();
        ImmutableMap.Builder candleBuilder = ImmutableMap.builder();
        for (DyeColor color : DyeColor.values()) {
            glassBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "stained_glass"));
            glassPaneBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "stained_glass_pane"));
            terracottaBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "terracotta"));
            woolBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "wool"));
            carpetBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "carpet"));
            concreteBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "concrete"));
            concretePowderBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "concrete_powder"));
            shulkerBoxBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "shulker_box"));
            candleBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "candle"));
        }
        GLASS_MAP = glassBuilder.build();
        GLASS_PANE_MAP = glassPaneBuilder.build();
        TERRACOTTA_MAP = terracottaBuilder.build();
        WOOL_MAP = woolBuilder.build();
        CARPET_MAP = carpetBuilder.build();
        CONCRETE_MAP = concreteBuilder.build();
        CONCRETE_POWDER_MAP = concretePowderBuilder.build();
        SHULKER_BOX_MAP = shulkerBoxBuilder.build();
        CANDLE_MAP = candleBuilder.build();
        paintablePredicate = (parent, child, dir) -> {
            if (parent == null) {
                return true;
            }
            if (!parent.getClass().equals(child.getClass())) {
                return false;
            }
            return parent.getPaintingColor() == child.getPaintingColor();
        };
        gtPipePredicate = (parent, child, direction) -> {
            if (parent == null) {
                return true;
            }
            if (!paintablePredicate.test(parent, child, direction)) {
                return false;
            }
            return parent.isConnected((Direction)direction) && child.isConnected(direction.getOpposite());
        };
    }

    private static class AE2CallWrapper {
        private AE2CallWrapper() {
        }

        static Set<CableBusBlockEntity> collect(BlockEntity first, int limit) {
            return BreadthFirstBlockSearch.conditionalBlockEntitySearch(CableBusBlockEntity.class, (CableBusBlockEntity)first, AE2CallWrapper::ae2CablePredicate, limit, limit * 6);
        }

        static boolean isAE2Cable(BlockEntity be) {
            return be instanceof CableBusBlockEntity;
        }

        static boolean ae2CablePredicate(CableBusBlockEntity parent, CableBusBlockEntity child, Direction direction) {
            if (parent == null) {
                return true;
            }
            Direction childDirection = direction.getOpposite();
            return parent.getPart(direction) == null && parent.getCableConnectionType(direction).isValid() && child.getPart(childDirection) == null && child.getCableConnectionType(childDirection).isValid() && parent.getColor() == child.getColor();
        }
    }
}

