/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class ConsumedBehaviour {
    public final int totalUses;

    public ConsumedBehaviour(int totalUses) {
        this.totalUses = totalUses;
    }

    public boolean useItemDurability(Player player, InteractionHand hand, ItemStack stack, ItemStack replacementStack) {
        int usesLeft = this.getUsesLeft(stack);
        if (!player.isCreative()) {
            if (--usesLeft <= 0) {
                if (replacementStack.isEmpty()) {
                    stack.shrink(1);
                } else {
                    player.setItemInHand(hand, replacementStack);
                }
                return true;
            }
            ConsumedBehaviour.setUsesLeft(stack, usesLeft);
        }
        return true;
    }

    public final int getUsesLeft(ItemStack stack) {
        CompoundTag tagCompound = stack.getTag();
        if (tagCompound == null || !tagCompound.contains("GT.UsesLeft", 3)) {
            return this.totalUses;
        }
        return tagCompound.getInt("GT.UsesLeft");
    }

    public static void setUsesLeft(ItemStack itemStack, int usesLeft) {
        CompoundTag tagCompound = itemStack.getTag();
        if (tagCompound == null) {
            tagCompound = new CompoundTag();
            itemStack.setTag(tagCompound);
        }
        tagCompound.putInt("GT.UsesLeft", usesLeft);
    }
}

