/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacadeItemBehaviour
implements ISubItemHandler,
ICustomDescriptionId {
    public static final Supplier<List<BlockState>> DEFAULT_FACADES = GTMemoizer.memoize(() -> {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        states.add(Blocks.STONE.defaultBlockState());
        states.add(GTBlocks.COIL_CUPRONICKEL.getDefaultState());
        states.add(Blocks.GLASS.defaultBlockState());
        return states;
    });

    @Override
    @Nullable
    public Component getItemName(ItemStack stack) {
        BlockState facadeState = FacadeItemBehaviour.getFacadeState(stack);
        return Component.translatable((String)stack.getDescriptionId(), (Object[])new Object[]{facadeState.getBlock().getName()});
    }

    @Override
    public void fillItemCategory(Item item, CreativeModeTab category, NonNullList<ItemStack> items) {
        for (BlockState facadeState : DEFAULT_FACADES.get()) {
            ItemStack resultStack = item.getDefaultInstance();
            FacadeItemBehaviour.setFacadeState(resultStack, facadeState);
            items.add((Object)resultStack);
        }
    }

    public static void setFacadeState(ItemStack itemStack, BlockState facadeState) {
        if (!FacadeItemBehaviour.isValidFacade(facadeState)) {
            facadeState = Blocks.STONE.defaultBlockState();
        }
        CompoundTag tagCompound = itemStack.getOrCreateTag();
        Tag stateTag = (Tag)BlockState.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)facadeState).result().orElse(new CompoundTag());
        tagCompound.put("Facade", stateTag);
    }

    public static boolean isValidFacade(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        return FacadeItemBehaviour.isValidFacade(blockItem.getBlock().defaultBlockState());
    }

    public static boolean isValidFacade(BlockState state) {
        return !state.hasBlockEntity() && state.getRenderShape() == RenderShape.MODEL;
    }

    public static BlockState getFacadeState(ItemStack itemStack) {
        BlockState nullableState = FacadeItemBehaviour.getFacadeStateNullable(itemStack);
        if (nullableState == null) {
            return Blocks.STONE.defaultBlockState();
        }
        return nullableState;
    }

    public static BlockState getFacadeStateNullable(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock().defaultBlockState();
        }
        BlockState unsafeState = FacadeItemBehaviour.getFacadeStateUnsafe(itemStack);
        if (unsafeState == null) {
            ItemStack unsafeStack = FacadeItemBehaviour.getFacadeStackUnsafe(itemStack);
            Item item2 = unsafeStack.getItem();
            if (item2 instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item2;
                return blockItem.getBlock().defaultBlockState();
            }
            return null;
        }
        return unsafeState;
    }

    @Nullable
    private static BlockState getFacadeStateUnsafe(ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.getTag();
        if (tagCompound == null || !tagCompound.contains("Facade", 10)) {
            return null;
        }
        return BlockState.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tagCompound.getCompound("Facade")).result().orElse(null);
    }

    @Deprecated
    @NotNull
    private static ItemStack getFacadeStackUnsafe(ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.getTag();
        if (tagCompound == null || !tagCompound.contains("Facade", 10)) {
            return ItemStack.EMPTY;
        }
        ItemStack facadeStack = ItemStack.of((CompoundTag)tagCompound.getCompound("Facade"));
        if (facadeStack.isEmpty() || !FacadeItemBehaviour.isValidFacade(facadeStack)) {
            return ItemStack.EMPTY;
        }
        return facadeStack;
    }
}

