/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.mojang.serialization.Codec;
import java.util.EnumMap;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.util.Lazy;

public enum GTArmorMaterials implements ArmorMaterial,
StringRepresentable
{
    GOGGLES("goggles", 0, (EnumMap)Util.make(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 0);
        map.put(ArmorItem.Type.LEGGINGS, 0);
        map.put(ArmorItem.Type.CHESTPLATE, 0);
        map.put(ArmorItem.Type.HELMET, 0);
    }), 50, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.0f, (Lazy<Ingredient>)((Lazy)() -> Ingredient.EMPTY)),
    JETPACK("jetpack", 0, (EnumMap)Util.make(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 0);
        map.put(ArmorItem.Type.LEGGINGS, 0);
        map.put(ArmorItem.Type.CHESTPLATE, 0);
        map.put(ArmorItem.Type.HELMET, 0);
    }), 50, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.0f, (Lazy<Ingredient>)((Lazy)() -> Ingredient.EMPTY)),
    ARMOR("armor", 0, (EnumMap)Util.make(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 0);
        map.put(ArmorItem.Type.LEGGINGS, 0);
        map.put(ArmorItem.Type.CHESTPLATE, 0);
        map.put(ArmorItem.Type.HELMET, 0);
    }), 50, SoundEvents.ARMOR_EQUIP_GENERIC, 5.0f, 0.0f, (Lazy<Ingredient>)((Lazy)() -> Ingredient.EMPTY)),
    BAD_PPE_EQUIPMENT("bad_ppe_equipment", 10, (EnumMap)Util.make(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 2);
        map.put(ArmorItem.Type.CHESTPLATE, 3);
        map.put(ArmorItem.Type.HELMET, 1);
    }), 10, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.0f, (Lazy<Ingredient>)((Lazy)() -> Ingredient.EMPTY)),
    GOOD_PPE_EQUIPMENT("good_ppe_equipment", 20, (EnumMap)Util.make(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 2);
        map.put(ArmorItem.Type.LEGGINGS, 5);
        map.put(ArmorItem.Type.CHESTPLATE, 6);
        map.put(ArmorItem.Type.HELMET, 2);
    }), 10, SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.0f, (Lazy<Ingredient>)((Lazy)() -> Ingredient.EMPTY));

    public static final Codec<GTArmorMaterials> CODEC;
    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantmentValue;
    private final SoundEvent equipSound;
    private final float toughness;
    private final float knockbackResistance;
    private final Lazy<Ingredient> repairIngredient;

    public int getDurabilityForType(ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int getDefenseForType(ArmorItem.Type type) {
        return this.protectionFunctionForType.get(type);
    }

    public Ingredient getRepairIngredient() {
        return (Ingredient)this.repairIngredient.get();
    }

    public String getName() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name;
    }

    @Generated
    private GTArmorMaterials(String name, int durabilityMultiplier, EnumMap<ArmorItem.Type, Integer> protectionFunctionForType, int enchantmentValue, SoundEvent equipSound, float toughness, float knockbackResistance, Lazy<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionFunctionForType = protectionFunctionForType;
        this.enchantmentValue = enchantmentValue;
        this.equipSound = equipSound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = repairIngredient;
    }

    @Generated
    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    @Generated
    public SoundEvent getEquipSound() {
        return this.equipSound;
    }

    @Generated
    public float getToughness() {
        return this.toughness;
    }

    @Generated
    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }

    static {
        CODEC = StringRepresentable.fromEnum(GTArmorMaterials::values);
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 13);
            map.put(ArmorItem.Type.LEGGINGS, 15);
            map.put(ArmorItem.Type.CHESTPLATE, 16);
            map.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

