/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorLogicSuite;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class NightvisionGoggles
extends ArmorLogicSuite {
    public NightvisionGoggles(int energyPerUse, long capacity, int voltageTier, ArmorItem.Type slot) {
        super(energyPerUse, capacity, voltageTier, slot);
    }

    @Override
    public void onArmorTick(Level world, @NotNull Player player, @NotNull ItemStack itemStack) {
        int nightVisionTimer;
        IElectricItem item = GTCapabilityHelper.getElectricItem(itemStack);
        if (item == null) {
            return;
        }
        CompoundTag data = itemStack.getOrCreateTag();
        int toggleTimer = data.contains("toggleTimer") ? data.getByte("toggleTimer") : 0;
        int n = nightVisionTimer = data.contains("nightVisionTimer") ? data.getInt("nightVisionTimer") : 400;
        if (this.type == ArmorItem.Type.HELMET) {
            boolean nightVision;
            boolean bl = nightVision = data.contains("nightVision") && data.getBoolean("nightVision");
            if (toggleTimer == 0 && KeyBind.ARMOR_MODE_SWITCH.isKeyDown(player)) {
                nightVision = !nightVision;
                toggleTimer = 5;
                if (item.getCharge() < 4L) {
                    nightVision = false;
                    player.displayClientMessage((Component)Component.translatable((String)"metaarmor.nms.nightvision.error"), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)("metaarmor.nms.nightvision." + (nightVision ? "enabled" : "disabled"))), true);
                }
            }
            if (nightVision) {
                player.removeEffect(MobEffects.BLINDNESS);
                if (nightVisionTimer <= 240) {
                    nightVisionTimer = 400;
                    player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, true, false));
                    item.discharge(this.energyPerUse, this.tier, true, false, false);
                }
            } else {
                player.removeEffect(MobEffects.NIGHT_VISION);
            }
            data.putBoolean("nightVision", nightVision);
        }
        if (nightVisionTimer > 0) {
            --nightVisionTimer;
        }
        if (toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
        }
        data.putInt("nightVisionTimer", nightVisionTimer);
        data.putByte("toggleTimer", (byte)toggleTimer);
    }

    public static void disableNightVision(@NotNull Level world, Player player, boolean sendMsg) {
        if (!world.isClientSide) {
            player.removeEffect(MobEffects.NIGHT_VISION);
            if (sendMsg) {
                player.displayClientMessage((Component)Component.translatable((String)"metaarmor.message.nightvision.disabled"), true);
            }
        }
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return GTCEu.id("textures/armor/nightvision_goggles.png");
    }

    @Override
    public void addInfo(ItemStack itemStack, List<Component> lines) {
        super.addInfo(itemStack, lines);
        if (this.type == ArmorItem.Type.HELMET) {
            CompoundTag nbtData = itemStack.getOrCreateTag();
            boolean nv = nbtData.getBoolean("nightVision");
            if (nv) {
                lines.add((Component)Component.translatable((String)"metaarmor.message.nightvision.enabled"));
            } else {
                lines.add((Component)Component.translatable((String)"metaarmor.message.nightvision.disabled"));
            }
        }
    }
}

