/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.armor.ArmorLogicSuite;
import com.gregtechceu.gtceu.api.item.armor.ArmorUtils;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.armor.IStepAssist;
import com.gregtechceu.gtceu.core.IFireImmuneEntity;
import com.gregtechceu.gtceu.utils.input.KeyBind;
import com.gregtechceu.gtceu.utils.input.SyncedKeyMappings;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class QuarkTechSuite
extends ArmorLogicSuite
implements IStepAssist {
    public static final Reference2IntMap<MobEffect> potionRemovalCost = new Reference2IntOpenHashMap();
    private float charge = 0.0f;
    private static final byte RUNNING_TIMER = 10;
    private static final byte JUMPING_TIMER = 10;
    private static final double LEGGING_ACCEL = 0.085;
    @OnlyIn(value=Dist.CLIENT)
    protected ArmorUtils.ModularHUD HUD;

    public QuarkTechSuite(ArmorItem.Type slot, int energyPerUse, long capacity, int tier) {
        super(energyPerUse, capacity, tier, slot);
        potionRemovalCost.put((Object)MobEffects.POISON, 10000);
        potionRemovalCost.put((Object)MobEffects.WITHER, 25000);
        potionRemovalCost.put((Object)MobEffects.CONFUSION, 8000);
        potionRemovalCost.put((Object)MobEffects.DIG_SLOWDOWN, 12500);
        potionRemovalCost.put((Object)MobEffects.MOVEMENT_SLOWDOWN, 9000);
        potionRemovalCost.put((Object)MobEffects.UNLUCK, 5000);
        if (GTCEu.isClientSide() && this.shouldDrawHUD()) {
            this.HUD = new ArmorUtils.ModularHUD();
        }
    }

    @Override
    public void onArmorTick(Level world, Player player, ItemStack itemStack) {
        int boostedJumpTimer;
        IElectricItem item = GTCapabilityHelper.getElectricItem(itemStack);
        if (item == null) {
            return;
        }
        CompoundTag data = itemStack.getOrCreateTag();
        byte toggleTimer = data.contains("toggleTimer") ? data.getByte("toggleTimer") : (byte)0;
        int nightVisionTimer = data.contains("nightVisionTimer") ? data.getInt("nightVisionTimer") : 400;
        byte runningTimer = data.contains("runningTimer") ? (byte)data.getByte("runningTimer") : (byte)10;
        int n = boostedJumpTimer = data.contains("boostedJumpTimer") ? (int)data.getByte("boostedJumpTimer") : 10;
        if (!(player.getItemBySlot(EquipmentSlot.CHEST).is((Item)GTItems.QUANTUM_CHESTPLATE.get()) || player.getItemBySlot(EquipmentSlot.CHEST).is((Item)GTItems.QUANTUM_CHESTPLATE_ADVANCED.get()) || world.isClientSide)) {
            ((IFireImmuneEntity)player).gtceu$setFireImmune(false);
        }
        boolean ret = false;
        if (this.type == ArmorItem.Type.HELMET) {
            boolean nightVision;
            ret = this.supplyAir(item, player) || this.supplyFood(item, player);
            QuarkTechSuite.removeNegativeEffects(item, player);
            boolean bl = nightVision = data.contains("nightVision") && data.getBoolean("nightVision");
            if (toggleTimer == 0 && KeyBind.ARMOR_MODE_SWITCH.isKeyDown(player)) {
                nightVision = !nightVision;
                toggleTimer = 5;
                if (item.getCharge() < 4L) {
                    nightVision = false;
                    player.displayClientMessage((Component)Component.translatable((String)"metaarmor.nms.nightvision.error"), true);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)("metaarmor.nms.nightvision." + (nightVision ? "enabled" : "disabled"))), true);
                }
            }
            if (nightVision) {
                player.removeEffect(MobEffects.BLINDNESS);
                if (nightVisionTimer <= 240) {
                    nightVisionTimer = 400;
                    player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 400, 0, true, false));
                    item.discharge(4L, this.tier, true, false, false);
                }
            } else {
                player.removeEffect(MobEffects.NIGHT_VISION);
            }
            data.putBoolean("nightVision", nightVision);
            if (nightVisionTimer > 0) {
                --nightVisionTimer;
            }
            if (toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
            }
            data.putInt("nightVisionTimer", nightVisionTimer);
            data.putByte("toggleTimer", toggleTimer);
        } else if (this.type == ArmorItem.Type.CHESTPLATE && !player.fireImmune()) {
            ((IFireImmuneEntity)player).gtceu$setFireImmune(true);
            if (player.isOnFire()) {
                player.extinguishFire();
            }
        } else if (this.type == ArmorItem.Type.LEGGINGS) {
            boolean canUseEnergy = item.canUse(this.energyPerUse / 100);
            boolean sprinting = SyncedKeyMappings.VANILLA_FORWARD.isKeyDown(player) && player.isSprinting();
            boolean jumping = SyncedKeyMappings.VANILLA_JUMP.isKeyDown(player);
            boolean sneaking = SyncedKeyMappings.VANILLA_SNEAK.isKeyDown(player);
            if (canUseEnergy && sprinting && runningTimer == 0) {
                runningTimer = 10;
                item.discharge(this.energyPerUse / 100, item.getTier(), true, false, false);
            }
            if (canUseEnergy && (player.onGround() || player.isInWater()) && sprinting) {
                float speed = 0.25f;
                if (player.isInWater()) {
                    speed = 0.1f;
                    if (jumping) {
                        player.push(0.0, 0.1, 0.0);
                        player.hurtMarked = true;
                    }
                }
                player.moveRelative(speed, new Vec3(0.0, 0.0, 1.0));
            } else if (canUseEnergy && player.isInWater() && (sneaking || jumping)) {
                if (sneaking) {
                    player.push(0.0, -0.085, 0.0);
                }
                if (jumping) {
                    player.push(0.0, 0.085, 0.0);
                }
            }
            if (runningTimer > 0) {
                runningTimer = (byte)(runningTimer - 1);
            }
            data.putByte("runningTimer", runningTimer);
        } else if (this.type == ArmorItem.Type.BOOTS) {
            boolean boostedJump;
            boolean canUseEnergy = item.canUse(this.energyPerUse / 100);
            boolean jumping = SyncedKeyMappings.VANILLA_JUMP.isKeyDown(player);
            boolean bl = boostedJump = data.contains("boostedJump") && data.getBoolean("boostedJump");
            if (boostedJumpTimer == 0 && KeyBind.BOOTS_ENABLE.isKeyDown(player)) {
                boostedJump = !boostedJump;
                boostedJumpTimer = 10;
                player.displayClientMessage((Component)Component.translatable((String)("metaarmor.nms.boosted_jump." + (boostedJump ? "enabled" : "disabled"))), true);
            }
            if (boostedJump) {
                if (!world.isClientSide) {
                    boolean onGround;
                    boolean bl2 = onGround = !data.contains("onGround") || data.getBoolean("onGround");
                    if (onGround && !player.onGround() && jumping) {
                        item.discharge(this.energyPerUse / 100, item.getTier(), true, false, false);
                        ret = true;
                    }
                    if (player.onGround() != onGround) {
                        data.putBoolean("onGround", player.onGround());
                    }
                } else {
                    if (canUseEnergy && player.onGround()) {
                        this.charge = 1.0f;
                    }
                    Vec3 delta = player.getDeltaMovement();
                    if (delta.y >= 0.0 && this.charge > 0.0f && !player.isInWater()) {
                        if (jumping) {
                            if (this.charge == 1.0f) {
                                player.setDeltaMovement(delta.x * 3.6, delta.y, delta.z * 3.6);
                            }
                            player.addDeltaMovement(new Vec3(0.0, (double)this.charge * 0.32, 0.0));
                            this.charge = (float)((double)this.charge * 0.7);
                        } else if (this.charge < 1.0f) {
                            this.charge = 0.0f;
                        }
                    }
                }
            }
            data.putBoolean("boostedJump", boostedJump);
            if (boostedJumpTimer > 0) {
                boostedJumpTimer = (byte)(boostedJumpTimer - 1);
            }
            data.putInt("boostedJumpTimer", boostedJumpTimer);
        }
        if (ret) {
            player.inventoryMenu.sendAllDataToRemote();
        }
    }

    public boolean supplyAir(@NotNull IElectricItem item, Player player) {
        int air = player.getAirSupply();
        if (item.canUse(this.energyPerUse / 100) && air < 100) {
            player.setAirSupply(air + 200);
            item.discharge(this.energyPerUse / 100, item.getTier(), true, false, false);
            return true;
        }
        return false;
    }

    public boolean supplyFood(@NotNull IElectricItem item, Player player) {
        if (item.canUse(this.energyPerUse / 10) && player.getFoodData().needsFood()) {
            int slotId = -1;
            IItemHandler playerInv = player.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElse(null);
            if (playerInv instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable items = (IItemHandlerModifiable)playerInv;
                for (int i = 0; i < items.getSlots(); ++i) {
                    ItemStack current = items.getStackInSlot(i);
                    if (current.getFoodProperties((LivingEntity)player) == null) continue;
                    slotId = i;
                    break;
                }
                if (slotId > -1) {
                    ItemStack stack = items.getStackInSlot(slotId);
                    InteractionResultHolder<ItemStack> result = ArmorUtils.eat(player, stack);
                    if ((stack = (ItemStack)result.getObject()).isEmpty()) {
                        items.setStackInSlot(slotId, ItemStack.EMPTY);
                    }
                    if (result.getResult() == InteractionResult.SUCCESS) {
                        item.discharge(this.energyPerUse / 10, item.getTier(), true, false, false);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static void removeNegativeEffects(@NotNull IElectricItem item, Player player) {
        for (MobEffectInstance effect : new LinkedList(player.getActiveEffects())) {
            MobEffect potion = effect.getEffect();
            int cost = potionRemovalCost.getOrDefault((Object)potion, -1);
            if (cost == -1 || !item.canUse(cost *= effect.getAmplifier() + 1)) continue;
            item.discharge(cost, item.getTier(), true, false, false);
            player.removeEffect(potion);
        }
    }

    @Override
    public int damageArmor(LivingEntity entity, ItemStack itemStack, DamageSource source, int damage, EquipmentSlot equipmentSlot) {
        IElectricItem item = GTCapabilityHelper.getElectricItem(itemStack);
        if (item != null) {
            item.discharge((long)this.energyPerUse / 100L * (long)damage, item.getTier(), true, false, false);
        }
        return super.damageArmor(entity, itemStack, source, damage, equipmentSlot);
    }

    @Override
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ItemStack currentChest = (ItemStack)Minecraft.getInstance().player.getInventory().armor.get(EquipmentSlot.CHEST.getIndex());
        String armorTexture = "quark_tech_suite";
        if (currentChest.is((Item)GTItems.QUANTUM_CHESTPLATE_ADVANCED.get())) {
            armorTexture = "advanced_quark_tech_suite";
        }
        return slot != EquipmentSlot.LEGS ? GTCEu.id(String.format("textures/armor/%s_1.png", armorTexture)) : GTCEu.id(String.format("textures/armor/%s_2.png", armorTexture));
    }

    @Override
    public double getDamageAbsorption() {
        return this.type == ArmorItem.Type.CHESTPLATE ? 1.2 : 1.0;
    }

    @Override
    public float getHeatResistance() {
        return 0.5f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(ItemStack item, GuiGraphics guiGraphics) {
        QuarkTechSuite.addCapacityHUD(item, this.HUD);
        this.HUD.draw(guiGraphics);
        this.HUD.reset();
    }

    @Override
    public void addInfo(ItemStack itemStack, List<Component> lines) {
        super.addInfo(itemStack, lines);
        if (this.type == ArmorItem.Type.HELMET) {
            CompoundTag nbtData = itemStack.getOrCreateTag();
            boolean nv = nbtData.getBoolean("nightVision");
            if (nv) {
                lines.add((Component)Component.translatable((String)"metaarmor.message.nightvision.enabled"));
            } else {
                lines.add((Component)Component.translatable((String)"metaarmor.message.nightvision.disabled"));
            }
            lines.add((Component)Component.translatable((String)"metaarmor.tooltip.potions"));
            lines.add((Component)Component.translatable((String)"metaarmor.tooltip.breath"));
            lines.add((Component)Component.translatable((String)"metaarmor.tooltip.autoeat"));
        } else if (this.type == ArmorItem.Type.CHESTPLATE) {
            lines.add((Component)Component.translatable((String)"metaarmor.tooltip.burning"));
            lines.add((Component)Component.translatable((String)"metaarmor.tooltip.freezing"));
        } else if (this.type == ArmorItem.Type.LEGGINGS) {
            lines.add((Component)Component.translatable((String)"metaarmor.tooltip.speed"));
        } else if (this.type == ArmorItem.Type.BOOTS) {
            lines.add((Component)Component.translatable((String)"metaarmor.tooltip.stepassist"));
            lines.add((Component)Component.translatable((String)"metaarmor.tooltip.falldamage"));
            lines.add((Component)Component.translatable((String)"metaarmor.tooltip.jump"));
        }
    }

    @Override
    public boolean isPPE() {
        return true;
    }
}

