/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class ProspectingBehavior
implements IToolBehavior {
    public static final ProspectingBehavior INSTANCE = new ProspectingBehavior();

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        Item item = context.getItemInHand().getItem();
        if (item instanceof IGTTool) {
            IGTTool tool = (IGTTool)item;
            int tier = tool.getTotalHarvestLevel(context.getItemInHand());
            int depth = tool.getProspectingDepth();
            ProspectingBehavior.findOres(context.getLevel(), context.getClickedPos(), context.getClickedFace(), depth).forEach(c -> {
                if (context.getPlayer() != null && context.getLevel().isClientSide()) {
                    context.getPlayer().sendSystemMessage((Component)c);
                }
            });
            return InteractionResult.SUCCESS;
        }
        return IToolBehavior.super.onItemUse(context);
    }

    private static List<MutableComponent> findOres(Level level, BlockPos pos, Direction direction, int depth) {
        HashSet<BlockState> foundBlocks = new HashSet<BlockState>();
        HashSet<Fluid> foundFluids = new HashSet<Fluid>();
        for (int i = 0; i < depth; ++i) {
            for (BlockPos position : ProspectingBehavior.getSurroundingBlocks(pos, direction)) {
                if (!level.getFluidState(position).isEmpty()) {
                    foundFluids.add(level.getFluidState(position).getType());
                    continue;
                }
                foundBlocks.add(level.getBlockState(position));
            }
            if (direction.getAxis().isHorizontal()) {
                for (BlockPos position : ProspectingBehavior.getSurroundingBlocks(pos.below(), direction)) {
                    if (!level.getFluidState(position).isEmpty()) {
                        foundFluids.add(level.getFluidState(position).getType());
                        continue;
                    }
                    foundBlocks.add(level.getBlockState(position));
                }
            }
            pos = pos.relative(direction.getOpposite());
        }
        ArrayList<MutableComponent> out = new ArrayList<MutableComponent>();
        int cnt = 0;
        for (BlockState blockState : foundBlocks) {
            if (blockState.is(Tags.Blocks.ORES)) {
                out.add(Component.translatable((String)"item.gtceu.tool.behavior.prospecting.ore", (Object[])new Object[]{blockState.getBlock().getName()}));
                continue;
            }
            if (blockState.isAir()) {
                out.add(Component.translatable((String)"item.gtceu.tool.behavior.prospecting.air"));
                continue;
            }
            ++cnt;
        }
        for (Fluid fluid : foundFluids) {
            if (fluid.isSame((Fluid)Fluids.WATER)) {
                out.add(Component.translatable((String)"item.gtceu.tool.behavior.prospecting.water"));
            }
            if (!fluid.isSame((Fluid)Fluids.LAVA)) continue;
            out.add(Component.translatable((String)"item.gtceu.tool.behavior.prospecting.lava"));
        }
        if (cnt >= 2) {
            out.add(Component.translatable((String)"item.gtceu.tool.behavior.prospecting.changing"));
        }
        return out;
    }

    private static List<BlockPos> getSurroundingBlocks(BlockPos pos, Direction dir) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>();
        for (Direction direction : Direction.values()) {
            if (direction.getAxis() == dir.getAxis()) continue;
            out.add(pos.relative(direction));
        }
        out.add(pos);
        return out;
    }
}

