/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TorchPlaceBehavior
implements IToolBehavior {
    public static final TorchPlaceBehavior INSTANCE = new TorchPlaceBehavior();

    protected TorchPlaceBehavior() {
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        int i;
        int cachedTorchSlot;
        ItemStack slotStack;
        Player player = context.getPlayer();
        InteractionHand hand = context.getHand();
        ItemStack stack = player.getItemInHand(hand);
        CompoundTag behaviourTag = ToolHelper.getBehaviorsTag(stack);
        if (!context.getPlayer().getOffhandItem().isEmpty()) {
            return InteractionResult.PASS;
        }
        if (!behaviourTag.getBoolean("TorchPlacing")) {
            return InteractionResult.PASS;
        }
        if (behaviourTag.getBoolean("TorchPlacing$Slot") && TorchPlaceBehavior.checkAndPlaceTorch(context, slotStack = (cachedTorchSlot = behaviourTag.getInt("TorchPlacing$Slot")) < 0 ? (ItemStack)player.getInventory().offhand.get(0) : (ItemStack)player.getInventory().items.get(cachedTorchSlot))) {
            return InteractionResult.SUCCESS;
        }
        for (i = 0; i < player.getInventory().offhand.size(); ++i) {
            slotStack = (ItemStack)player.getInventory().offhand.get(i);
            if (!TorchPlaceBehavior.checkAndPlaceTorch(context, slotStack)) continue;
            behaviourTag.putInt("TorchPlacing$Slot", -(i + 1));
            return InteractionResult.SUCCESS;
        }
        for (i = 0; i < player.getInventory().items.size(); ++i) {
            slotStack = (ItemStack)player.getInventory().items.get(i);
            if (!TorchPlaceBehavior.checkAndPlaceTorch(context, slotStack)) continue;
            behaviourTag.putInt("TorchPlacing$Slot", i);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean checkAndPlaceTorch(UseOnContext context, ItemStack slotStack) {
        if (slotStack.isEmpty()) {
            return false;
        }
        Item slotItem = slotStack.getItem();
        if (slotItem != Items.TORCH && !slotStack.is(TagUtil.createItemTag("torches"))) {
            return false;
        }
        if (context.getPlayer() == null) {
            return false;
        }
        if (!(slotItem instanceof BlockItem)) {
            return false;
        }
        BlockItem slotItemBlock = (BlockItem)slotItem;
        BlockPos pos = context.getClickedPos();
        BlockState state = context.getLevel().getBlockState(pos);
        if (!state.canBeReplaced()) {
            pos = pos.relative(context.getClickedFace());
        }
        if (context.getPlayer().mayUseItemAt(pos, context.getClickedFace(), slotStack)) {
            UseOnContext torchContext = new UseOnContext(context.getLevel(), context.getPlayer(), context.getHand(), slotStack, context.getHitResult());
            BlockPlaceContext blockPlaceContext = new BlockPlaceContext(torchContext);
            InteractionResult placed = slotItemBlock.place(blockPlaceContext);
            boolean wasPlaced = placed.consumesAction();
            if (wasPlaced) {
                SoundType sound = slotItemBlock.getBlock().getSoundType(slotItemBlock.getBlock().defaultBlockState());
                context.getLevel().playSound(context.getPlayer(), pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            }
            return wasPlaced;
        }
        return false;
    }

    @Override
    public void addBehaviorNBT(@NotNull ItemStack stack, @NotNull CompoundTag tag) {
        tag.putBoolean("TorchPlacing", true);
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level Level2, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"item.gtceu.tool.behavior.torch_place"));
    }
}

