/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.WidgetUtils;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.gui.editor.EditableUI;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BlockBreakerMachine
extends TieredEnergyMachine
implements IAutoOutputItem,
IFancyUIMachine,
IMachineLife,
IControllable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(BlockBreakerMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputItems;
    @Persisted
    protected final NotifiableItemStackHandler cache;
    @Persisted
    protected final CustomItemStackHandler chargerInventory;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected TickableSubscription batterySubs;
    @Nullable
    protected TickableSubscription breakerSubs;
    @Nullable
    protected ISubscription exportItemSubs;
    @Nullable
    protected ISubscription energySubs;
    private final int inventorySize;
    @DescSynced
    private int blockBreakProgress = 0;
    private float currentHardness;
    private final long energyPerTick;
    public final float efficiencyMultiplier;
    @Persisted
    @DescSynced
    private boolean isWorkingEnabled = true;
    public static BiFunction<ResourceLocation, Integer, EditableMachineUI> EDITABLE_UI_CREATOR = Util.memoize((path, inventorySize) -> new EditableMachineUI("misc", (ResourceLocation)path, () -> {
        WidgetGroup template = BlockBreakerMachine.createTemplate(inventorySize).createDefault();
        ProgressWidget energyBar = BlockBreakerMachine.createEnergyBar().createDefault();
        SlotWidget batterySlot = BlockBreakerMachine.createBatterySlot().createDefault();
        WidgetGroup energyGroup = new WidgetGroup(0, 0, energyBar.getSize().width, energyBar.getSize().height + 20);
        batterySlot.setSelfPosition(new Position((energyBar.getSize().width - 18) / 2, energyBar.getSize().height + 1));
        energyGroup.addWidget((Widget)energyBar);
        energyGroup.addWidget((Widget)batterySlot);
        WidgetGroup group = new WidgetGroup(0, 0, Math.max(energyGroup.getSize().width + template.getSize().width + 4 + 8, 172), Math.max(template.getSize().height + 8, energyGroup.getSize().height + 8));
        Size size = group.getSize();
        energyGroup.setSelfPosition(new Position(3, (size.height - energyGroup.getSize().height) / 2));
        template.setSelfPosition(new Position((size.width - 4 - template.getSize().width) / 2 + 4, (size.height - template.getSize().height) / 2));
        group.addWidget((Widget)energyGroup);
        group.addWidget((Widget)template);
        return group;
    }, (template, machine) -> {
        if (machine instanceof BlockBreakerMachine) {
            BlockBreakerMachine blockBreakerMachine = (BlockBreakerMachine)machine;
            BlockBreakerMachine.createTemplate(inventorySize).setupUI((WidgetGroup)template, blockBreakerMachine);
            BlockBreakerMachine.createEnergyBar().setupUI((WidgetGroup)template, blockBreakerMachine);
            BlockBreakerMachine.createBatterySlot().setupUI((WidgetGroup)template, blockBreakerMachine);
        }
    }));

    public BlockBreakerMachine(IMachineBlockEntity holder, int tier, Object ... ignoredArgs) {
        super(holder, tier, new Object[0]);
        this.inventorySize = (tier + 1) * (tier + 1);
        this.cache = this.createCacheItemHandler();
        this.chargerInventory = this.createChargerItemHandler();
        this.energyPerTick = GTValues.V[tier - 1];
        this.setOutputFacingItems(this.getFrontFacing().getOpposite());
        this.efficiencyMultiplier = 1.0f - BlockBreakerMachine.getEfficiencyMultiplier(tier);
    }

    public static float getEfficiencyMultiplier(int tier) {
        float efficiencyMultiplier = 1.0f - 0.2f * ((float)tier - 1.0f);
        if (efficiencyMultiplier > 1.0f) {
            efficiencyMultiplier = 1.0f;
        } else if (efficiencyMultiplier < 0.1f) {
            efficiencyMultiplier = 0.1f;
        }
        efficiencyMultiplier = 1.0f - efficiencyMultiplier;
        return efficiencyMultiplier;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected CustomItemStackHandler createChargerItemHandler() {
        CustomItemStackHandler handler = new CustomItemStackHandler();
        handler.setFilter(item -> GTCapabilityHelper.getElectricItem(item) != null || ConfigHolder.INSTANCE.compat.energy.nativeEUToFE && GTCapabilityHelper.getForgeEnergyItem(item) != null);
        return handler;
    }

    protected NotifiableItemStackHandler createCacheItemHandler() {
        return new NotifiableItemStackHandler(this, this.inventorySize, IO.BOTH, IO.OUT);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote()) {
            Level level = this.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.getServer().tell((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
                serverLevel.getServer().tell((Runnable)new TickTask(0, this::updateBreakerSubscription));
            }
            this.exportItemSubs = this.cache.addChangedListener(this::updateAutoOutputSubscription);
            this.energySubs = this.energyContainer.addChangedListener(() -> {
                this.updateBatterySubscription();
                this.updateBreakerSubscription();
            });
            this.chargerInventory.setOnContentsChanged(this::updateBatterySubscription);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.energySubs != null) {
            this.energySubs.unsubscribe();
            this.energySubs = null;
        }
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
    }

    @Override
    public void onMachineRemoved() {
        this.clearInventory((IItemHandlerModifiable)this.chargerInventory);
        this.clearInventory((IItemHandlerModifiable)this.cache.storage);
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateBreakerSubscription();
        this.updateAutoOutputSubscription();
    }

    public void updateBreakerSubscription() {
        if (this.drainEnergy(true) && !this.getLevel().getBlockState(this.getPos().relative(this.getFrontFacing())).isAir() && this.isWorkingEnabled) {
            this.breakerSubs = this.subscribeServerTick(this.breakerSubs, this::breakerUpdate);
        } else if (this.breakerSubs != null) {
            this.blockBreakProgress = 0;
            this.breakerSubs.unsubscribe();
            this.breakerSubs = null;
        }
    }

    public void breakerUpdate() {
        float hardness;
        BlockState blockState;
        BlockPos pos;
        if (this.blockBreakProgress > 0) {
            --this.blockBreakProgress;
            this.drainEnergy(false);
            if (this.blockBreakProgress == 0) {
                pos = this.getPos().relative(this.getFrontFacing());
                blockState = this.getLevel().getBlockState(pos);
                hardness = blockState.getBlock().defaultDestroyTime();
                if (hardness >= 0.0f && Math.abs(hardness - this.currentHardness) < 0.5f) {
                    List<ItemStack> drops = this.tryDestroyBlockAndGetDrops(pos);
                    for (ItemStack drop : drops) {
                        ItemStack remainder = this.tryFillCache(drop);
                        if (remainder.isEmpty()) continue;
                        if (this.getOutputFacingItems() == null) {
                            Block.popResource((Level)this.getLevel(), (BlockPos)this.getPos(), (ItemStack)remainder);
                            continue;
                        }
                        Block.popResource((Level)this.getLevel(), (BlockPos)this.getPos().relative(this.getOutputFacingItems()), (ItemStack)remainder);
                    }
                }
                this.currentHardness = 0.0f;
            }
        }
        if (this.blockBreakProgress == 0) {
            pos = this.getPos().relative(this.getFrontFacing());
            blockState = this.getLevel().getBlockState(pos);
            hardness = blockState.getBlock().defaultDestroyTime();
            boolean skipBlock = blockState.isAir();
            if (hardness >= 0.0f && !skipBlock) {
                int ticksPerOneDurability = 5;
                int totalTicksPerBlock = (int)Math.ceil((float)ticksPerOneDurability * hardness);
                this.blockBreakProgress = (int)Math.ceil((float)totalTicksPerBlock * this.efficiencyMultiplier);
                this.currentHardness = hardness;
            }
        }
        this.updateBreakerSubscription();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        if (this.blockBreakProgress > 0) {
            BlockPos pos = this.getPos().relative(this.getFrontFacing());
            BlockState blockState = this.getLevel().getBlockState(pos);
            this.getLevel().addDestroyBlockEffect(pos, blockState);
        }
    }

    private List<ItemStack> tryDestroyBlockAndGetDrops(BlockPos pos) {
        List drops = Block.getDrops((BlockState)this.getLevel().getBlockState(pos), (ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)pos, null, null, (ItemStack)ItemStack.EMPTY);
        this.getLevel().destroyBlock(pos, false);
        return drops;
    }

    private ItemStack tryFillCache(ItemStack stack) {
        for (int i = 0; i < this.cache.getSlots(); ++i) {
            if (this.cache.insertItemInternal(i, stack, true).getCount() == stack.getCount()) continue;
            return this.tryFillCache(this.cache.insertItemInternal(i, stack, false));
        }
        return stack;
    }

    public boolean drainEnergy(boolean simulate) {
        long resultEnergy = this.energyContainer.getEnergyStored() - this.energyPerTick;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.removeEnergy(this.energyPerTick);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setAutoOutputItems(boolean allow) {
        this.autoOutputItems = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return false;
    }

    @Override
    public void setAllowInputFromOutputSideItems(boolean allow) {
    }

    @Override
    public void setOutputFacingItems(@Nullable Direction outputFacing) {
        this.outputFacingItems = outputFacing;
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacing = this.getOutputFacingItems();
        if (this.isAutoOutputItems() && !this.cache.isEmpty() && outputFacing != null && GTTransferUtils.hasAdjacentItemHandler(this.getLevel(), this.getPos(), outputFacing)) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.cache.exportToNearby(this.getOutputFacingItems());
            }
            this.updateAutoOutputSubscription();
        }
    }

    protected void updateBatterySubscription() {
        if (this.energyContainer.dischargeOrRechargeEnergyContainers((IItemHandlerModifiable)this.chargerInventory, 0, true)) {
            this.batterySubs = this.subscribeServerTick(this.batterySubs, this::chargeBattery);
        } else if (this.batterySubs != null) {
            this.batterySubs.unsubscribe();
            this.batterySubs = null;
        }
    }

    protected void chargeBattery() {
        if (!this.energyContainer.dischargeOrRechargeEnergyContainers((IItemHandlerModifiable)this.chargerInventory, 0, false)) {
            this.updateBatterySubscription();
        }
    }

    @Override
    public boolean shouldWeatherOrTerrainExplosion() {
        return false;
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        if (facing == this.getOutputFacingItems()) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.isWorkingEnabled = workingEnabled;
        this.updateBreakerSubscription();
    }

    protected static EditableUI<SlotWidget, BlockBreakerMachine> createBatterySlot() {
        return new EditableUI<SlotWidget, BlockBreakerMachine>("battery_slot", SlotWidget.class, () -> {
            SlotWidget slotWidget = new SlotWidget();
            slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY});
            return slotWidget;
        }, (slotWidget, machine) -> {
            slotWidget.setHandlerSlot((IItemHandlerModifiable)machine.chargerInventory, 0);
            slotWidget.setCanPutItems(true);
            slotWidget.setCanTakeItems(true);
            slotWidget.setHoverTooltips((Component[])LangHandler.getMultiLang("gtceu.gui.charger_slot.tooltip", GTValues.VNF[machine.getTier()], GTValues.VNF[machine.getTier()]).toArray(new MutableComponent[0]));
        });
    }

    protected static EditableUI<WidgetGroup, BlockBreakerMachine> createTemplate(int inventorySize) {
        return new EditableUI<WidgetGroup, BlockBreakerMachine>("functional_container", WidgetGroup.class, () -> {
            int rowSize = (int)Math.sqrt(inventorySize);
            WidgetGroup main = new WidgetGroup(0, 0, rowSize * 18 + 8, rowSize * 18 + 8);
            for (int y = 0; y < rowSize; ++y) {
                for (int x = 0; x < rowSize; ++x) {
                    int index = y * rowSize + x;
                    SlotWidget slotWidget = new SlotWidget();
                    slotWidget.initTemplate();
                    slotWidget.setSelfPosition(new Position(4 + x * 18, 4 + y * 18));
                    slotWidget.setBackground(new IGuiTexture[]{GuiTextures.SLOT});
                    slotWidget.setId("slot_" + index);
                    main.addWidget((Widget)slotWidget);
                }
            }
            main.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
            return main;
        }, (group, machine) -> WidgetUtils.widgetByIdForEach(group, "^slot_[0-9]+$", SlotWidget.class, slot -> {
            int index = WidgetUtils.widgetIdIndex((Widget)slot);
            if (index >= 0 && index < machine.cache.getSlots()) {
                slot.setHandlerSlot(machine.cache, index);
                slot.setCanTakeItems(true);
                slot.setCanPutItems(false);
            }
        }));
    }

    @Override
    @Nullable
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (!(player.isShiftKeyDown() || this.hasFrontFacing() && side == this.getFrontFacing())) {
                return GuiTextures.TOOL_IO_FACING_ROTATION;
            }
        } else {
            if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
                return this.isWorkingEnabled ? GuiTextures.TOOL_PAUSE : GuiTextures.TOOL_START;
            }
            if (toolTypes.contains(GTToolType.SCREWDRIVER) && side == this.getOutputFacingItems()) {
                return GuiTextures.TOOL_ALLOW_INPUT;
            }
        }
        return super.sideTips(player, pos, state, toolTypes, side);
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!playerIn.isShiftKeyDown() && !this.isRemote()) {
            ItemStack tool = playerIn.getItemInHand(hand);
            if (tool.getDamageValue() >= tool.getMaxDamage()) {
                return InteractionResult.PASS;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return InteractionResult.PASS;
            }
            Direction itemFacing = this.outputFacingItems;
            if (gridSide != itemFacing) {
                this.setOutputFacingItems(gridSide);
            } else {
                this.setOutputFacingItems(null);
            }
            return InteractionResult.sidedSuccess((boolean)playerIn.level().isClientSide);
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    protected InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        IControllable controllable = GTCapabilityHelper.getControllable(this.getLevel(), this.getPos(), gridSide);
        if (controllable != null) {
            if (!this.isRemote()) {
                controllable.setWorkingEnabled(!controllable.isWorkingEnabled());
                playerIn.sendSystemMessage((Component)Component.translatable((String)(controllable.isWorkingEnabled() ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled")));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    @Generated
    public Direction getOutputFacingItems() {
        return this.outputFacingItems;
    }

    @Override
    @Generated
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    @Generated
    public CustomItemStackHandler getChargerInventory() {
        return this.chargerInventory;
    }

    @Override
    @Generated
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }
}

