/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.WeightedMaterial;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.machine.trait.BedrockOreMinerLogic;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BedrockOreMinerMachine
extends WorkableElectricMultiblockMachine
implements ITieredMachine {
    private final int tier;

    public BedrockOreMinerMachine(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new BedrockOreMinerLogic(this);
    }

    @Override
    public BedrockOreMinerLogic getRecipeLogic() {
        return (BedrockOreMinerLogic)super.getRecipeLogic();
    }

    public int getEnergyTier() {
        List energyContainer = this.getCapabilitiesFlat(IO.IN, EURecipeCapability.CAP);
        if (energyContainer == null) {
            return this.tier;
        }
        EnergyContainerList energyCont = new EnergyContainerList(energyContainer.stream().filter(IEnergyContainer.class::isInstance).map(IEnergyContainer.class::cast).toList());
        return Math.min(this.tier + 1, Math.max(this.tier, GTUtil.getFloorTierByVoltage(energyCont.getInputVoltage())));
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        if (this.isFormed()) {
            int energyContainer = this.getEnergyTier();
            long maxVoltage = GTValues.V[energyContainer];
            String voltageName = GTValues.VNF[energyContainer];
            textList.add((Component)Component.translatable((String)"gtceu.multiblock.max_energy_per_tick", (Object[])new Object[]{maxVoltage, voltageName}));
            if (this.getRecipeLogic().getVeinMaterials() != null) {
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.ore_rig.drilled_ores_list").withStyle(ChatFormatting.GREEN));
                List<WeightedMaterial> drilledOres = this.getRecipeLogic().getVeinMaterials();
                for (WeightedMaterial entry : drilledOres) {
                    MutableComponent fluidInfo = entry.material().getLocalizedName().withStyle(ChatFormatting.GREEN);
                    textList.add((Component)Component.translatable((String)"gtceu.multiblock.ore_rig.drilled_ore_entry", (Object[])new Object[]{fluidInfo}).withStyle(ChatFormatting.GRAY));
                }
                MutableComponent amountInfo = Component.literal((String)(FormattingUtil.formatNumbers((long)this.getRecipeLogic().getOreToProduce() * 20L / 20L) + "/s")).withStyle(ChatFormatting.BLUE);
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.ore_rig.ore_amount", (Object[])new Object[]{amountInfo}).withStyle(ChatFormatting.GRAY));
            } else {
                MutableComponent noOre = Component.translatable((String)"gtceu.multiblock.fluid_rig.no_fluid_in_area").withStyle(ChatFormatting.RED);
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.ore_rig.drilled_ores_list").withStyle(ChatFormatting.GREEN));
                textList.add((Component)Component.translatable((String)"gtceu.multiblock.ore_rig.drilled_ore_entry", (Object[])new Object[]{noOre}).withStyle(ChatFormatting.GRAY));
            }
        } else {
            MutableComponent tooltip = Component.translatable((String)"gtceu.multiblock.invalid_structure.tooltip").withStyle(ChatFormatting.GRAY);
            textList.add((Component)Component.translatable((String)"gtceu.multiblock.invalid_structure").withStyle(Style.EMPTY.withColor(ChatFormatting.RED).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)tooltip))));
        }
    }

    public static int getDepletionChance(int tier) {
        if (tier == 2) {
            return 1;
        }
        if (tier == 3) {
            return 2;
        }
        if (tier == 4) {
            return 8;
        }
        return 1;
    }

    public static int getRigMultiplier(int tier) {
        if (tier == 2) {
            return 1;
        }
        if (tier == 3) {
            return 4;
        }
        if (tier == 4) {
            return 16;
        }
        return 1;
    }

    public static Block getCasingState(int tier) {
        if (tier == 2) {
            return (Block)GTBlocks.CASING_STEEL_SOLID.get();
        }
        if (tier == 3) {
            return (Block)GTBlocks.CASING_TITANIUM_STABLE.get();
        }
        if (tier == 4) {
            return (Block)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get();
        }
        return (Block)GTBlocks.CASING_STEEL_SOLID.get();
    }

    public static Block getFrameState(int tier) {
        if (tier == 2) {
            return (Block)((BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.Steel)).get();
        }
        if (tier == 3) {
            return (Block)((BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.Titanium)).get();
        }
        if (tier == 4) {
            return (Block)((BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.TungstenSteel)).get();
        }
        return (Block)((BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)GTMaterials.Steel)).get();
    }

    public static ResourceLocation getBaseTexture(int tier) {
        if (tier == 2) {
            return GTCEu.id("block/casings/solid/machine_casing_solid_steel");
        }
        if (tier == 3) {
            return GTCEu.id("block/casings/solid/machine_casing_stable_titanium");
        }
        if (tier == 4) {
            return GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel");
        }
        return GTCEu.id("block/casings/solid/machine_casing_solid_steel");
    }

    @Override
    @Generated
    public int getTier() {
        return this.tier;
    }
}

