/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric.gcym;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IFluidRenderMulti;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LargeMixerMachine
extends WorkableElectricMultiblockMachine
implements IFluidRenderMulti {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LargeMixerMachine.class, WorkableElectricMultiblockMachine.MANAGED_FIELD_HOLDER);
    @DescSynced
    @RequireRerender
    @NotNull
    private Set<BlockPos> fluidBlockOffsets = new HashSet<BlockPos>();

    public LargeMixerMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        IFluidRenderMulti.super.onStructureFormed();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        IFluidRenderMulti.super.onStructureInvalid();
    }

    @Override
    @NotNull
    public Set<BlockPos> saveOffsets() {
        Direction up = RelativeDirection.UP.getRelative(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        Direction back = this.getFrontFacing().getOpposite();
        Direction clockWise = RelativeDirection.RIGHT.getRelative(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        Direction counterClockWise = RelativeDirection.LEFT.getRelative(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
        BlockPos pos = this.getPos();
        BlockPos center = pos.relative(up, 3);
        HashSet<BlockPos> offsets = new HashSet<BlockPos>();
        for (int i = 0; i < 3; ++i) {
            center = center.relative(back);
            if (i % 2 == 0) {
                offsets.add(center.subtract((Vec3i)pos));
            }
            offsets.add(center.relative(clockWise).subtract((Vec3i)pos));
            offsets.add(center.relative(counterClockWise).subtract((Vec3i)pos));
        }
        return offsets;
    }

    @Override
    @NotNull
    @Generated
    public Set<BlockPos> getFluidBlockOffsets() {
        return this.fluidBlockOffsets;
    }

    @Override
    @Generated
    public void setFluidBlockOffsets(@NotNull Set<BlockPos> fluidBlockOffsets) {
        if (fluidBlockOffsets == null) {
            throw new NullPointerException("fluidBlockOffsets is marked non-null but is null");
        }
        this.fluidBlockOffsets = fluidBlockOffsets;
    }
}

