/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric.research;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationHatch;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.recipe.CWURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableComputationContainer;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.DataBankMachine;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class NetworkSwitchMachine
extends DataBankMachine
implements IOpticalComputationProvider {
    public static final int EUT_PER_HATCH = GTValues.VA[5];
    private final MultipleComputationHandler computationHandler = new MultipleComputationHandler(this);

    public NetworkSwitchMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    protected int calculateEnergyUsage() {
        int receivers = 0;
        int transmitters = 0;
        for (IMultiPart part : this.getParts()) {
            Block block = part.self().getBlockState().getBlock();
            if (PartAbility.COMPUTATION_DATA_RECEPTION.isApplicable(block)) {
                ++receivers;
            }
            if (!PartAbility.COMPUTATION_DATA_TRANSMISSION.isApplicable(block)) continue;
            ++transmitters;
        }
        return GTValues.VA[5] * (receivers + transmitters);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        ArrayList<IOpticalComputationHatch> receivers = new ArrayList<IOpticalComputationHatch>();
        ArrayList<IOpticalComputationHatch> transmitters = new ArrayList<IOpticalComputationHatch>();
        for (IMultiPart part : this.getParts()) {
            ArrayList<IOpticalComputationHatch> list;
            Block block = part.self().getBlockState().getBlock();
            if (PartAbility.COMPUTATION_DATA_RECEPTION.isApplicable(block)) {
                list = receivers;
            } else {
                if (!PartAbility.COMPUTATION_DATA_TRANSMISSION.isApplicable(block)) continue;
                list = transmitters;
            }
            if (part instanceof IOpticalComputationHatch) {
                IOpticalComputationHatch hatch = (IOpticalComputationHatch)((Object)part);
                list.add(hatch);
                continue;
            }
            List<RecipeHandlerList> handlerLists = part.getRecipeHandlers();
            for (RecipeHandlerList handlerList : handlerLists) {
                for (IRecipeHandler<?> cwu : handlerList.getCapability(CWURecipeCapability.CAP)) {
                    if (!(cwu instanceof IOpticalComputationHatch)) continue;
                    IOpticalComputationHatch hatch = (IOpticalComputationHatch)((Object)cwu);
                    list.add(hatch);
                }
            }
        }
        this.computationHandler.onStructureForm(receivers, transmitters);
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.computationHandler.reset();
    }

    @Override
    public int getEnergyUsage() {
        return this.isFormed() ? this.computationHandler.getEUt() : 0;
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isActive() && !this.getRecipeLogic().isWaiting() ? this.computationHandler.requestCWUt(cwut, simulate, seen) : 0;
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return this.isFormed() ? this.computationHandler.getMaxCWUt(seen) : 0;
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        return true;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        MultiblockDisplayText.builder(textList, this.isFormed()).setWorkingStatus(true, this.isActive() && this.isWorkingEnabled()).setWorkingStatusKeys("gtceu.multiblock.idling", "gtceu.multiblock.idling", "gtceu.multiblock.data_bank.providing").addEnergyUsageExactLine(this.getEnergyUsage()).addComputationUsageLine(this.computationHandler.getMaxCWUtForDisplay()).addWorkingStatusLine();
    }

    private class MultipleComputationHandler
    extends NotifiableComputationContainer {
        private final Set<IOpticalComputationHatch> providers;
        private final Set<IOpticalComputationHatch> transmitters;
        private int EUt;
        private boolean tickSaturated;
        private long timerCWUt;

        public MultipleComputationHandler(MetaMachine machine) {
            super(machine, IO.IN, false);
            this.providers = new ObjectOpenHashSet();
            this.transmitters = new ObjectOpenHashSet();
            this.timerCWUt = -1L;
        }

        private void onStructureForm(Collection<IOpticalComputationHatch> providers, Collection<IOpticalComputationHatch> transmitters) {
            this.reset();
            this.providers.addAll(providers);
            this.transmitters.addAll(transmitters);
            this.EUt = (providers.size() + transmitters.size()) * EUT_PER_HATCH;
        }

        private void reset() {
            this.providers.clear();
            this.transmitters.clear();
            this.EUt = 0;
        }

        @Override
        public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
            if (seen.contains(this)) {
                return 0;
            }
            seen.add(this);
            if (cwut == 0) {
                return 0;
            }
            long timer = NetworkSwitchMachine.this.getOffsetTimer();
            if (this.timerCWUt == timer) {
                if (this.tickSaturated) {
                    return 0;
                }
            } else {
                this.timerCWUt = timer;
                this.tickSaturated = false;
            }
            ArrayList<IOpticalComputationProvider> bridgeSeen = new ArrayList<IOpticalComputationProvider>(seen);
            int allocatedCWUt = 0;
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(bridgeSeen)) continue;
                int allocated = provider.requestCWUt(cwut, simulate, seen);
                allocatedCWUt += allocated;
                if ((cwut -= allocated) != 0) continue;
                break;
            }
            if (!simulate && allocatedCWUt == 0) {
                this.tickSaturated = true;
            }
            return allocatedCWUt;
        }

        public int getMaxCWUtForDisplay() {
            ArrayList<IOpticalComputationProvider> seen = new ArrayList<IOpticalComputationProvider>();
            seen.add(this);
            ArrayList<IOpticalComputationProvider> bridgeSeen = new ArrayList<IOpticalComputationProvider>(seen);
            int maximumCWUt = 0;
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(bridgeSeen)) continue;
                maximumCWUt += provider.getMaxCWUt(seen);
            }
            return maximumCWUt;
        }

        @Override
        public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
            if (seen.contains(this)) {
                return 0;
            }
            seen.add(this);
            ArrayList<IOpticalComputationProvider> bridgeSeen = new ArrayList<IOpticalComputationProvider>(seen);
            int maximumCWUt = 0;
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(bridgeSeen)) continue;
                maximumCWUt += provider.getMaxCWUt(seen);
            }
            return maximumCWUt;
        }

        @Override
        public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
            if (seen.contains(this)) {
                return false;
            }
            seen.add(this);
            for (IOpticalComputationHatch provider : this.providers) {
                if (!provider.canBridge(seen)) continue;
                return true;
            }
            return false;
        }

        private boolean hasNonBridgingConnections() {
            ArrayList<IOpticalComputationProvider> seen = new ArrayList<IOpticalComputationProvider>();
            for (IOpticalComputationHatch provider : this.providers) {
                if (provider.canBridge(seen)) continue;
                return true;
            }
            return false;
        }

        @Override
        public IOpticalComputationProvider getComputationProvider() {
            return this;
        }

        @Generated
        private int getEUt() {
            return this.EUt;
        }
    }
}

