/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ItemBusPartMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class SteamItemBusPartMachine
extends ItemBusPartMachine {
    private final String autoTooltipKey;

    public SteamItemBusPartMachine(IMachineBlockEntity holder, IO io, Object ... args) {
        super(holder, 1, io, args);
        this.autoTooltipKey = io == IO.IN ? "gtceu.gui.item_auto_input.tooltip" : "gtceu.gui.item_auto_output.tooltip";
    }

    @Override
    @NotNull
    public ModularUI createUI(@NotNull Player entityPlayer) {
        int rowSize = (int)Math.sqrt(this.getInventorySize());
        int xOffset = rowSize == 10 ? 9 : 0;
        ModularUI modular = new ModularUI(176 + xOffset * 2, 18 + 18 * rowSize + 105, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks)}).widget((Widget)new LabelWidget(10, 5, this.getBlockState().getBlock().getDescriptionId())).widget((Widget)new ToggleButtonWidget(7 + xOffset, 18 + 18 * rowSize, 18, 18, (IGuiTexture)GuiTextures.BUTTON_ITEM_OUTPUT, this::isWorkingEnabled, this::setWorkingEnabled).setShouldUseBaseBackground().setTooltipText(this.autoTooltipKey)).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.getInventory(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks), 7 + xOffset, 18 + 18 * rowSize + 24, true));
        for (int y = 0; y < rowSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                int index = y * rowSize + x;
                modular.widget((Widget)new SlotWidget((IItemHandlerModifiable)this.getInventory().storage, index, 88 - rowSize * 9 + x * 18 + xOffset, 18 + y * 18 + 6, true, this.io.support(IO.IN)).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT_STEAM.get(ConfigHolder.INSTANCE.machines.steelSteamMultiblocks)));
            }
        }
        return modular;
    }

    @Override
    public boolean swapIO() {
        IMachineBlockEntity newHolder;
        MetaMachine metaMachine;
        BlockPos blockPos = this.getHolder().pos();
        MachineDefinition newDefinition = null;
        if (this.io == IO.IN) {
            newDefinition = GTMachines.STEAM_EXPORT_BUS;
        } else if (this.io == IO.OUT) {
            newDefinition = GTMachines.STEAM_IMPORT_BUS;
        }
        if (newDefinition == null) {
            return false;
        }
        BlockState newBlockState = newDefinition.getBlock().defaultBlockState();
        this.getLevel().setBlockAndUpdate(blockPos, newBlockState);
        BlockEntity blockEntity = this.getLevel().getBlockEntity(blockPos);
        if (blockEntity instanceof IMachineBlockEntity && (metaMachine = (newHolder = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof SteamItemBusPartMachine) {
            SteamItemBusPartMachine newMachine = (SteamItemBusPartMachine)metaMachine;
            newMachine.setFrontFacing(this.getFrontFacing());
            newMachine.setUpwardsFacing(this.getUpwardsFacing());
        }
        return true;
    }
}

