/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.owner;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.machine.owner.ArgonautsOwner;
import com.gregtechceu.gtceu.common.machine.owner.FTBOwner;
import com.gregtechceu.gtceu.common.machine.owner.PlayerOwner;
import com.gregtechceu.gtceu.common.machine.owner.RegisterOwnerTypeEvent;
import com.gregtechceu.gtceu.config.ConfigHolder;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MachineOwner {
    private static Function<UUID, MachineOwner> machineOwnerGenerator;
    public static final UUID EMPTY;
    protected static final Map<UUID, MachineOwner> MACHINE_OWNERS;
    protected static final Map<UUID, PlayerOwner> PLAYER_OWNERS;
    @NotNull
    protected final UUID playerUUID;

    protected MachineOwner(UUID playerUUID) {
        this.playerUUID = playerUUID == null ? EMPTY : playerUUID;
    }

    public abstract UUID getUUID();

    public abstract String getName();

    public abstract Component getTypeDisplayName();

    public static void init() {
        RegisterOwnerTypeEvent event = new RegisterOwnerTypeEvent();
        if (GTCEu.Mods.isFTBTeamsLoaded()) {
            event.register(0, FTBOwner::new);
        } else if (GTCEu.Mods.isArgonautsLoaded()) {
            event.register(0, ArgonautsOwner::new);
        } else {
            event.register(0, PlayerOwner::new);
        }
        ModLoader.get().postEvent((Event)event);
        machineOwnerGenerator = event.ownershipProvider;
    }

    public void displayInfo(List<Component> compList) {
        compList.add((Component)Component.translatable((String)"behavior.portable_scanner.machine_ownership", (Object[])new Object[]{this.getTypeDisplayName()}));
    }

    public abstract @UnmodifiableView @NotNull Set<UUID> getMembers();

    public boolean isPlayerInTeam(Player player) {
        return this.isPlayerInTeam(player.getUUID());
    }

    public abstract boolean isPlayerInTeam(UUID var1);

    public boolean isPlayerFriendly(Player player) {
        return this.isPlayerFriendly(player.getUUID());
    }

    public abstract boolean isPlayerFriendly(UUID var1);

    @Nullable
    public static MachineOwner getOwner(UUID playerUUID) {
        if (playerUUID == null) {
            return null;
        }
        return MACHINE_OWNERS.computeIfAbsent(playerUUID, machineOwnerGenerator);
    }

    @Nullable
    public static PlayerOwner getPlayerOwner(UUID playerUUID) {
        if (playerUUID == null) {
            return null;
        }
        return PLAYER_OWNERS.computeIfAbsent(playerUUID, PlayerOwner::new);
    }

    public static boolean canOpenOwnerMachine(Player player, MetaMachine machine) {
        if (!ConfigHolder.INSTANCE.machines.onlyOwnerGUI) {
            return true;
        }
        if (player.hasPermissions(ConfigHolder.INSTANCE.machines.ownerOPBypass)) {
            return true;
        }
        MachineOwner owner = machine.getOwner();
        if (owner == null) {
            return true;
        }
        return owner.isPlayerInTeam(player) || owner.isPlayerFriendly(player);
    }

    public static boolean canBreakOwnerMachine(Player player, MetaMachine machine) {
        if (!ConfigHolder.INSTANCE.machines.onlyOwnerBreak) {
            return true;
        }
        if (player.hasPermissions(ConfigHolder.INSTANCE.machines.ownerOPBypass)) {
            return true;
        }
        MachineOwner owner = machine.getOwner();
        if (owner == null) {
            return true;
        }
        return owner.isPlayerInTeam(player);
    }

    public static void displayPlayerInfo(List<Component> compList, UUID playerUUID) {
        ClientPacketListener connection;
        String playerName = UsernameCache.getLastKnownUsername((UUID)playerUUID);
        Object online = "gtceu.tooltip.status.trinary.";
        online = GTCEu.isClientThread() ? ((connection = Minecraft.getInstance().getConnection()) != null ? (String)online + connection.getOnlinePlayerIds().contains(playerUUID) : (String)online + "unknown") : (String)online + (ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayer(playerUUID) != null);
        compList.add((Component)Component.translatable((String)"behavior.portable_scanner.player_name", (Object[])new Object[]{playerName, Component.translatable((String)online)}));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MachineOwner)) {
            return false;
        }
        MachineOwner that = (MachineOwner)object;
        return this.playerUUID.equals(that.playerUUID);
    }

    public int hashCode() {
        return this.playerUUID.hashCode();
    }

    @NotNull
    @Generated
    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    static {
        EMPTY = new UUID(0L, 0L);
        MACHINE_OWNERS = new Object2ObjectOpenHashMap();
        PLAYER_OWNERS = new Object2ObjectOpenHashMap();
    }
}

