/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.PhantomFluidWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class QuantumTankMachine
extends TieredMachine
implements IAutoOutputFluid,
IInteractedMachine,
IControllable,
IDropSaveMachine,
IFancyUIMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(QuantumTankMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    public static Object2LongMap<MachineDefinition> TANK_CAPACITY = new Object2LongArrayMap();
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingFluids;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputFluids;
    @Persisted
    protected boolean allowInputFromOutputSideFluids;
    @Persisted
    private boolean isVoiding;
    private final long maxAmount;
    protected final FluidCache cache;
    @DescSynced
    private final CustomFluidTank lockedFluid;
    @DescSynced
    protected FluidStack stored = FluidStack.EMPTY;
    @DescSynced
    protected long storedAmount = 0L;
    @Nullable
    protected TickableSubscription autoOutputSubs;

    public QuantumTankMachine(IMachineBlockEntity holder, int tier, long maxAmount, Object ... args) {
        super(holder, tier);
        this.outputFacingFluids = this.getFrontFacing().getOpposite();
        this.maxAmount = maxAmount;
        this.cache = this.createCacheFluidHandler(args);
        this.lockedFluid = new CustomFluidTank(1000);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected FluidCache createCacheFluidHandler(Object ... args) {
        return new FluidCache(this);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().tell((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
        }
    }

    protected void onFluidChanged() {
        if (!this.isRemote()) {
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public boolean savePickClone() {
        return false;
    }

    @Override
    public boolean saveBreak() {
        return !this.stored.isEmpty();
    }

    @Override
    public void saveCustomPersistedData(@NotNull CompoundTag tag, boolean forDrop) {
        super.saveCustomPersistedData(tag, forDrop);
        if (!forDrop) {
            tag.put("lockedFluid", (Tag)this.lockedFluid.writeToNBT(new CompoundTag()));
        }
        tag.put("stored", (Tag)this.stored.writeToNBT(new CompoundTag()));
        tag.putLong("storedAmount", this.storedAmount);
    }

    @Override
    public void loadCustomPersistedData(@NotNull CompoundTag tag) {
        super.loadCustomPersistedData(tag);
        CompoundTag from = tag.contains("cache") ? tag.getCompound("cache") : tag;
        this.lockedFluid.readFromNBT(from.getCompound("lockedFluid"));
        FluidStack stored = FluidStack.loadFluidStackFromNBT((CompoundTag)tag.getCompound("stored"));
        this.stored = new FluidStack(stored, 1000);
        this.storedAmount = !tag.contains("storedAmount") ? (long)stored.getAmount() : tag.getLong("storedAmount");
        if (this.storedAmount == 0L && !stored.isEmpty()) {
            this.storedAmount = stored.getAmount();
        }
    }

    @Override
    @Nullable
    public IItemHandlerModifiable getItemHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        if (side == this.getFrontFacing()) {
            return null;
        }
        return super.getItemHandlerCap(side, useCoverCapability);
    }

    @Override
    @Nullable
    public IFluidHandlerModifiable getFluidHandlerCap(@Nullable Direction side, boolean useCoverCapability) {
        if (side == this.getFrontFacing()) {
            return null;
        }
        return super.getFluidHandlerCap(side, useCoverCapability);
    }

    @Override
    public void setAutoOutputFluids(boolean allow) {
        this.autoOutputFluids = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setOutputFacingFluids(@Nullable Direction outputFacing) {
        this.outputFacingFluids = outputFacing;
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isAutoOutputFluids();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.setAutoOutputFluids(isWorkingAllowed);
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacing = this.getOutputFacingFluids();
        if (this.isAutoOutputFluids() && !this.stored.isEmpty() && outputFacing != null && GTTransferUtils.hasAdjacentFluidHandler(this.getLevel(), this.getPos(), outputFacing)) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputFluids() && this.getOutputFacingFluids() != null) {
                this.cache.exportToNearby(this.getOutputFacingFluids());
            }
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        if (facing == this.outputFacingFluids) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hit.getDirection() == this.getFrontFacing() && !this.isRemote() && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.cache)) {
            return InteractionResult.SUCCESS;
        }
        return IInteractedMachine.super.onUse(state, world, pos, player, hand, hit);
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!playerIn.isShiftKeyDown() && !this.isRemote()) {
            ItemStack tool = playerIn.getItemInHand(hand);
            if (tool.getDamageValue() >= tool.getMaxDamage()) {
                return InteractionResult.PASS;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return InteractionResult.PASS;
            }
            if (gridSide != this.getOutputFacingFluids()) {
                this.setOutputFacingFluids(gridSide);
            } else {
                this.setOutputFacingFluids(null);
            }
            return InteractionResult.sidedSuccess((boolean)playerIn.level().isClientSide);
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            if (gridSide == this.getOutputFacingFluids()) {
                if (this.isAllowInputFromOutputSideFluids()) {
                    this.setAllowInputFromOutputSideFluids(false);
                    playerIn.sendSystemMessage((Component)Component.translatable((String)"gtceu.machine.basic.input_from_output_side.disallow").append((Component)Component.translatable((String)"gtceu.creative.tank.fluid")));
                } else {
                    this.setAllowInputFromOutputSideFluids(true);
                    playerIn.sendSystemMessage((Component)Component.translatable((String)"gtceu.machine.basic.input_from_output_side.allow").append((Component)Component.translatable((String)"gtceu.creative.tank.fluid")));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
    }

    public boolean isLocked() {
        return !this.lockedFluid.isEmpty();
    }

    protected void setLocked(boolean locked) {
        if (!this.stored.isEmpty() && locked) {
            FluidStack copied = new FluidStack(this.stored, 1000);
            this.lockedFluid.setFluid(copied);
        } else if (!locked) {
            this.lockedFluid.setFluid(FluidStack.EMPTY);
        }
    }

    protected void setLocked(FluidStack fluid) {
        if (fluid.isEmpty()) {
            this.setLocked(false);
        } else if (this.stored.isEmpty()) {
            this.lockedFluid.setFluid(fluid);
        } else if (this.stored.isFluidEqual(fluid)) {
            this.setLocked(true);
        }
    }

    public FluidStack getLockedFluid() {
        return this.lockedFluid.getFluid();
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 90, 63);
        group.addWidget((Widget)new ImageWidget(4, 4, 82, 55, (IGuiTexture)GuiTextures.DISPLAY)).addWidget((Widget)new LabelWidget(8, 8, "gtceu.gui.fluid_amount")).addWidget((Widget)new LabelWidget(8, 18, () -> FormattingUtil.formatBuckets(this.storedAmount)).setTextColor(-1).setDropShadow(false)).addWidget((Widget)new TankWidget(this.cache, 0, 68, 23, true, true).setShowAmount(false).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT)).addWidget((Widget)new PhantomFluidWidget((IFluidHandler)this.lockedFluid, 0, 68, 41, 18, 18, this::getLockedFluid, this::setLocked).setShowAmount(false).setBackground((IGuiTexture)ColorPattern.T_GRAY.rectTexture())).addWidget((Widget)new ToggleButtonWidget(4, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_FLUID_OUTPUT, this::isAutoOutputFluids, this::setAutoOutputFluids).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_auto_output.tooltip")).addWidget((Widget)new ToggleButtonWidget(22, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_LOCK, this::isLocked, this::setLocked).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_lock.tooltip")).addWidget((Widget)new ToggleButtonWidget(40, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_VOID, () -> this.isVoiding, b -> {
            this.isVoiding = b;
        }).setShouldUseBaseBackground().setTooltipText("gtceu.gui.fluid_voiding_partial.tooltip"));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @Override
    @Nullable
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (!(player.isShiftKeyDown() || this.hasFrontFacing() && side == this.getFrontFacing())) {
                return GuiTextures.TOOL_IO_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SCREWDRIVER)) {
            if (side == this.getOutputFacingFluids()) {
                return GuiTextures.TOOL_ALLOW_INPUT;
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET) && side == this.getFrontFacing()) {
            return null;
        }
        return super.sideTips(player, pos, state, toolTypes, side);
    }

    @Override
    @Generated
    public Direction getOutputFacingFluids() {
        return this.outputFacingFluids;
    }

    @Override
    @Generated
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    @Generated
    public boolean isAllowInputFromOutputSideFluids() {
        return this.allowInputFromOutputSideFluids;
    }

    @Override
    @Generated
    public void setAllowInputFromOutputSideFluids(boolean allowInputFromOutputSideFluids) {
        this.allowInputFromOutputSideFluids = allowInputFromOutputSideFluids;
    }

    @Generated
    public long getMaxAmount() {
        return this.maxAmount;
    }

    @Generated
    public FluidStack getStored() {
        return this.stored;
    }

    @Generated
    public long getStoredAmount() {
        return this.storedAmount;
    }

    protected class FluidCache
    extends MachineTrait
    implements IFluidHandler {
        private final Predicate<FluidStack> filter;

        public FluidCache(MetaMachine holder) {
            super(holder);
            this.filter = f -> !QuantumTankMachine.this.isLocked() || QuantumTankMachine.this.getLockedFluid().isFluidEqual(f);
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return new FluidStack(QuantumTankMachine.this.stored, GTMath.saturatedCast(QuantumTankMachine.this.storedAmount));
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            long free = QuantumTankMachine.this.isVoiding ? Long.MAX_VALUE : QuantumTankMachine.this.maxAmount - QuantumTankMachine.this.storedAmount;
            long canFill = 0L;
            if ((QuantumTankMachine.this.stored.isEmpty() || QuantumTankMachine.this.stored.isFluidEqual(resource)) && this.filter.test(resource)) {
                canFill = Math.min((long)resource.getAmount(), free);
            }
            if (action.execute() && canFill > 0L) {
                if (QuantumTankMachine.this.stored.isEmpty()) {
                    QuantumTankMachine.this.stored = new FluidStack(resource, 1000);
                }
                QuantumTankMachine.this.storedAmount = Math.min(QuantumTankMachine.this.maxAmount, QuantumTankMachine.this.storedAmount + canFill);
                QuantumTankMachine.this.onFluidChanged();
            }
            return (int)canFill;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (QuantumTankMachine.this.stored.isEmpty()) {
                return FluidStack.EMPTY;
            }
            long toDrain = Math.min(QuantumTankMachine.this.storedAmount, (long)maxDrain);
            FluidStack copy = new FluidStack(QuantumTankMachine.this.stored, (int)toDrain);
            if (action.execute() && toDrain > 0L) {
                QuantumTankMachine.this.storedAmount -= toDrain;
                if (QuantumTankMachine.this.storedAmount == 0L) {
                    QuantumTankMachine.this.stored = FluidStack.EMPTY;
                }
                QuantumTankMachine.this.onFluidChanged();
            }
            return copy.isEmpty() ? FluidStack.EMPTY : copy;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!resource.isFluidEqual(QuantumTankMachine.this.stored)) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        public int getTankCapacity(int tank) {
            return GTMath.saturatedCast(QuantumTankMachine.this.maxAmount);
        }

        public int getTanks() {
            return 1;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.filter.test(stack);
        }

        public void exportToNearby(Direction ... facings) {
            if (QuantumTankMachine.this.stored.isEmpty()) {
                return;
            }
            Level level = this.getMachine().getLevel();
            BlockPos pos = this.getMachine().getPos();
            for (Direction facing : facings) {
                Predicate<FluidStack> filter = this.getMachine().getFluidCapFilter(facing, IO.OUT);
                GTTransferUtils.getAdjacentFluidHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferFluidsFiltered(this, adj, filter));
            }
        }

        public ManagedFieldHolder getFieldHolder() {
            return MANAGED_FIELD_HOLDER;
        }
    }
}

